/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.smslib.EzTextingOutboundMessage;
import org.smslib.GatewayException;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;
import org.smslib.helper.Logger;
import org.smslib.http.HTTPGateway;

public class EzTextingHTTPGateway
extends HTTPGateway {
    Object SYNC_Commander;
    final String providerUrl = "https://app.eztexting.com";
    String username;
    String password;

    public EzTextingHTTPGateway(String id, String myUsername, String myPassword) {
        super(id);
        this.username = myUsername;
        this.password = myPassword;
        this.SYNC_Commander = new Object();
        this.setAttributes(5);
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway.", null, this.getGatewayId());
        super.startGateway();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Stopping gateway.", null, this.getGatewayId());
        super.stopGateway();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        URL url = null;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        request.add(new HTTPGateway.HttpHeader(this, "user", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "pass", this.password, false));
        url = new URL(this.providerUrl + "/api/credits/check/");
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        return Float.parseFloat(response.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        List<String> response;
        URL url = null;
        ArrayList<HTTPGateway.HttpHeader> request = new ArrayList<HTTPGateway.HttpHeader>();
        boolean ok = false;
        boolean isExpress = true;
        String subject = "";
        request.add(new HTTPGateway.HttpHeader(this, "user", this.username, false));
        request.add(new HTTPGateway.HttpHeader(this, "pass", this.password, false));
        request.add(new HTTPGateway.HttpHeader(this, "message", msg.getText(), false));
        request.add(new HTTPGateway.HttpHeader(this, "phonenumber", msg.getRecipient(), false));
        if (msg instanceof EzTextingOutboundMessage) {
            if (!((EzTextingOutboundMessage)msg).isExpress()) {
                isExpress = false;
            }
            subject = ((EzTextingOutboundMessage)msg).getSubject();
        }
        request.add(new HTTPGateway.HttpHeader(this, "express", isExpress ? "1" : "0", false));
        request.add(new HTTPGateway.HttpHeader(this, "subject", subject, false));
        url = new URL(this.providerUrl + "/api/sending/");
        Object object = this.SYNC_Commander;
        synchronized (object) {
            response = this.HttpPost(url, request);
        }
        if (response.get(0).length() == 1 && response.get(0).charAt(0) == '1') {
            msg.setDispatchDate(new Date());
            msg.setGatewayId(this.getGatewayId());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            ok = true;
        } else {
            Logger.getInstance().logError("Error sending message. Response: " + response.get(0), null, this.getGatewayId());
            switch (Integer.parseInt(response.get(0))) {
                case -1: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_AUTH);
                    break;
                }
                case -2: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.NO_CREDIT);
                    break;
                }
                case -5: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.LOCAL_OPTOUT);
                    break;
                }
                case -7: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.BAD_FORMAT);
                    break;
                }
                case -104: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GLOBAL_OPTOUT);
                    break;
                }
                case -106: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.BAD_NUMBER);
                    break;
                }
                case -10: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                    break;
                }
                default: {
                    msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                }
            }
            msg.setRefNo(null);
            msg.setDispatchDate(null);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            ok = false;
        }
        return ok;
    }
}

