/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lexeme
implements Comparable<Lexeme> {
    public static final int TYPE_CJK_NORMAL = 0;
    public static final int TYPE_CJK_SN = 1;
    public static final int TYPE_CJK_SF = 2;
    public static final int TYPE_CJK_UNKNOWN = 3;
    public static final int TYPE_NUM = 10;
    public static final int TYPE_NUMCOUNT = 11;
    public static final int TYPE_LETTER = 20;
    private int offset;
    private int begin;
    private int length;
    private String lexemeText;
    private int lexemeType;
    private Lexeme prev;
    private Lexeme next;

    public Lexeme(int offset, int begin, int length, int lexemeType) {
        this.offset = offset;
        this.begin = begin;
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        this.length = length;
        this.lexemeType = lexemeType;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Lexeme) {
            Lexeme other = (Lexeme)o;
            return this.offset == other.getOffset() && this.begin == other.getBegin() && this.length == other.getLength();
        }
        return false;
    }

    public int hashCode() {
        int absBegin = this.getBeginPosition();
        int absEnd = this.getEndPosition();
        return absBegin * 37 + absEnd * 31 + absBegin * absEnd % this.getLength() * 11;
    }

    @Override
    public int compareTo(Lexeme other) {
        if (this.begin < other.getBegin()) {
            return -1;
        }
        if (this.begin == other.getBegin()) {
            if (this.length > other.getLength()) {
                return -1;
            }
            if (this.length == other.getLength()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public boolean isOverlap(Lexeme other) {
        if (other != null) {
            if (this.getBeginPosition() <= other.getBeginPosition() && this.getEndPosition() >= other.getEndPosition()) {
                return true;
            }
            return this.getBeginPosition() >= other.getBeginPosition() && this.getEndPosition() <= other.getEndPosition();
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getBeginPosition() {
        return this.offset + this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEndPosition() {
        return this.offset + this.begin + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (this.length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        this.length = length;
    }

    public String getLexemeText() {
        if (this.lexemeText == null) {
            return "";
        }
        return this.lexemeText;
    }

    public void setLexemeText(String lexemeText) {
        if (lexemeText == null) {
            this.lexemeText = "";
            this.length = 0;
        } else {
            this.lexemeText = lexemeText;
            this.length = lexemeText.length();
        }
    }

    public int getLexemeType() {
        return this.lexemeType;
    }

    public void setLexemeType(int lexemeType) {
        this.lexemeType = lexemeType;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.getBeginPosition()).append("-").append(this.getEndPosition());
        strbuf.append(" : ").append(this.lexemeText).append(" : \t");
        switch (this.lexemeType) {
            case 0: {
                strbuf.append("CJK_NORMAL");
                break;
            }
            case 2: {
                strbuf.append("CJK_SUFFIX");
                break;
            }
            case 1: {
                strbuf.append("CJK_NAME");
                break;
            }
            case 3: {
                strbuf.append("UNKNOWN");
                break;
            }
            case 10: {
                strbuf.append("NUMEBER");
                break;
            }
            case 11: {
                strbuf.append("COUNT");
                break;
            }
            case 20: {
                strbuf.append("LETTER");
            }
        }
        return strbuf.toString();
    }

    Lexeme getPrev() {
        return this.prev;
    }

    void setPrev(Lexeme prev) {
        this.prev = prev;
    }

    Lexeme getNext() {
        return this.next;
    }

    void setNext(Lexeme next) {
        this.next = next;
    }
}

