/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.SQLException;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:30:28_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    @Override
    public void setFilter(Predicate predicate) throws SQLException {
        this.predicate = predicate;
    }

    @Override
    public Predicate getFilter() {
        return this.predicate;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 344);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean bl = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow >= 1);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        int n3;
        if (this.rowsetType == 1003) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 344);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        int n4 = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.presentRow = 0;
        for (n3 = 0; n3 < n4 && this.presentRow <= this.rowCount; ++n3) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n3 == n4) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n2)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 345);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }
}

