/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.impl;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiKeyConcurrentMap<K1, K2, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<K1, ConcurrentMap<K2, V>> map = new ConcurrentHashMap<K1, ConcurrentMap<K2, V>>();

    public boolean containsKey(K1 key1, K2 key2) {
        ConcurrentMap subMap = (ConcurrentMap)this.map.get(key1);
        return subMap != null && subMap.containsKey(key2);
    }

    public V put(K1 key1, K2 key2, V value) {
        ConcurrentMap<K2, V> subMap = this.getOrCreateSubMap(key1);
        return subMap.put(key2, value);
    }

    public V putIfAbsent(K1 key1, K2 key2, V value) {
        ConcurrentMap<K2, V> subMap = this.getOrCreateSubMap(key1);
        return subMap.putIfAbsent(key2, value);
    }

    public V get(K1 key1, K2 key2) {
        ConcurrentMap subMap = (ConcurrentMap)this.map.get(key1);
        if (subMap == null) {
            return null;
        }
        return subMap.get(key2);
    }

    private ConcurrentMap<K2, V> getOrCreateSubMap(K1 key1) {
        ConcurrentMap existingSubMap;
        ConcurrentMap subMap = (ConcurrentHashMap)this.map.get(key1);
        if (subMap == null && (existingSubMap = (ConcurrentMap)this.map.putIfAbsent(key1, subMap = new ConcurrentHashMap())) != null) {
            subMap = existingSubMap;
        }
        return subMap;
    }
}

