/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingSITNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;

public class ImportSettingSIT
extends ImportSetting {
    public ImportSettingSIT() {
        long l = ImportSettingSITNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingSIT(ImportSettingSIT importSettingSIT) {
        if (importSettingSIT == null) {
            String string = InternalResource.loadString("importSettingSIT", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingSIT);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingSIT", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingSITNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingSIT.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingSIT.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingSIT.getTargetPrjCoordSys());
        super.setDataType(DataType.RASTER);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingSIT));
    }

    public ImportSettingSIT(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingSIT(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingSITNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        ImportSettingSITNative.jni_SetPassword(this.getHandle(), string);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingSITNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingSITNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingSITNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingSITNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        ImportSettingSITNative.jni_SetIgnoreValues(this.getHandle(), dArray);
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingSITNative.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void setMultiBandImportMode(MultiBandImportMode multiBandImportMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiBandImportMode(MultiBandImportMode mode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (multiBandImportMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingSITNative.jni_SetMultiBandImportMode(this.getHandle(), multiBandImportMode.value());
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingSITNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingSITNative.jni_SetImportingAsGrid(this.getHandle(), bl);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingSITNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

