/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingKMLNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingKML
extends ImportSetting {
    public ImportSettingKML() {
        long l = ImportSettingKMLNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingKML(ImportSettingKML importSettingKML) {
        if (importSettingKML == null) {
            String string = InternalResource.loadString("ImportSettingKML", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = importSettingKML.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingKML", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingKMLNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingKML.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingKML.getTargetDatasource());
        this.setUnvisibleObjectIgnored(importSettingKML.isUnvisibleObjectIgnored());
        this.setImportingAsCAD(importSettingKML.isImportingAsCAD());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingKML));
    }

    public ImportSettingKML(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingKML(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingKML(String string, DatasourceConnectionInfo datasourceConnectionInfo, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }

    public boolean isUnvisibleObjectIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_GetUnvisibleObjectIgnored(this.getHandle());
    }

    public void setUnvisibleObjectIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetUnvisibleObjectIgnored(this.getHandle(), bl);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingKMLNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetImportEmptyDT(this.getHandle(), bl);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

