/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.navigation;

import com.supermap.analyst.navigation.InternalHandleDisposable;
import com.supermap.analyst.navigation.InternalResource;
import com.supermap.analyst.navigation.PathAnalystNative;
import com.supermap.analyst.navigation.PathInfo;
import com.supermap.analyst.navigation.RouteType;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;

public class PathAnalyst
extends InternalHandleDisposable {
    protected long m_handle = PathAnalystNative.jni_New();
    protected boolean m_bConnect = false;
    protected boolean m_bSetStartPoint = false;
    protected boolean m_bSetEndPoint = false;
    protected boolean m_bFind = false;

    public void dispose() {
        if (this.m_handle != 0L) {
            this._$1();
            PathAnalystNative.jni_Delete(this.m_handle);
        }
    }

    public boolean connectData(String string) {
        if (this.m_handle != 0L) {
            this.m_bConnect = PathAnalystNative.jni_ConnectData(this.m_handle, string);
            return this.m_bConnect;
        }
        return false;
    }

    public void setStartPoint(Point2D point2D) {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetStartPoint(this.m_handle, point2D.getX(), point2D.getY());
            this.m_bSetStartPoint = true;
        }
    }

    public void setEndPoint(Point2D point2D) {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetDestinationtPoint(this.m_handle, point2D.getX(), point2D.getY());
            this.m_bSetEndPoint = true;
        }
    }

    public boolean plan() {
        if (this.m_handle != 0L) {
            if (this.m_bConnect && this.m_bSetStartPoint && this.m_bSetEndPoint) {
                int n = PathAnalystNative.jni_Plan(this.m_handle);
                if (n == 1) {
                    this.m_bFind = true;
                    return true;
                }
            } else {
                if (!this.m_bConnect) {
                    String string = InternalResource.loadString("connectData", "Global_ArgumentNull", "navigation_resources");
                    throw new IllegalArgumentException(string);
                }
                if (!this.m_bSetStartPoint || !this.m_bSetEndPoint) {
                    String string = InternalResource.loadString("StartPoint or EndPoint", "Global_ArgumentNull", "navigation_resources");
                    throw new IllegalArgumentException(string);
                }
            }
        }
        return false;
    }

    public void setPoints(Point2Ds point2Ds) {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_RemovePoints(this.m_handle);
            if (point2Ds != null) {
                for (int i = 0; i < point2Ds.getCount(); ++i) {
                    PathAnalystNative.jni_SetAddWayPoint(this.m_handle, point2Ds.getItem(i).getX(), point2Ds.getItem(i).getY());
                }
            }
        }
    }

    public void setRouteMode(RouteType routeType) {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_SetRouteMode(this.m_handle, routeType.value());
        }
    }

    public Point2Ds getPathPoints() {
        Point2Ds point2Ds = new Point2Ds();
        if (this.m_handle != 0L && this.m_bFind) {
            double[] dArray = PathAnalystNative.jni_GetPathPoint(this.m_handle);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Point2D point2D = new Point2D();
                point2D.setX(dArray[i++]);
                point2D.setY(dArray[i]);
                point2Ds.add(point2D);
            }
        }
        return point2Ds;
    }

    public double getPathLength() {
        double d = 0.0;
        if (this.m_handle != 0L && this.m_bFind) {
            d = PathAnalystNative.jni_GetPathLength(this.m_handle);
        }
        return d;
    }

    public PathInfo[] getPathInfos() {
        PathInfo[] pathInfoArray = null;
        if (this.m_handle != 0L && this.m_bFind) {
            this._$1();
            long[] lArray = PathAnalystNative.jni_GetPathInfos(this.m_handle);
            pathInfoArray = new PathInfo[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                PathInfo pathInfo;
                pathInfoArray[i] = pathInfo = new PathInfo(lArray[i]);
            }
        }
        return pathInfoArray;
    }

    private void _$1() {
        if (this.m_handle != 0L) {
            PathAnalystNative.jni_ReleasePathInfos(this.m_handle);
        }
    }
}

