/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti.engine.impl.variable.VariableTypes;

public abstract class VariableScopeImpl
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;
    protected List<VariableInstanceEntity> variableInstanceList = null;
    protected ELContext cachedElContext;
    protected String id = null;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            this.variableInstanceList = new ArrayList<VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new ActivitiException("lazy loading outside command context");
            }
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
                this.variableInstanceList.add(variableInstance);
            }
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Object getVariable(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariable(variableName);
        }
        return null;
    }

    @Override
    public Object getVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        return null;
    }

    @Override
    public boolean hasVariables() {
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.keySet();
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    public void deleteVariablesInstanceForLeavingScope() {
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstanceList) {
            Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
            variableInstance.delete();
        }
        this.variableInstanceList.clear();
    }

    @Override
    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    @Override
    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityExecution());
    }

    protected void setVariable(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value, sourceActivityExecution);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.setVariable(variableName, value);
            } else {
                parentVariableScope.setVariable(variableName, value, sourceActivityExecution);
            }
            return;
        }
        this.createVariableLocal(variableName, value);
    }

    @Override
    public Object setVariableLocal(String variableName, Object value) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution());
    }

    public Object setVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance == null) {
            this.createVariableLocal(variableName, value);
        } else {
            this.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        }
        return null;
    }

    @Override
    public void createVariableLocal(String variableName, Object value) {
        this.createVariableLocal(variableName, value, this.getSourceActivityExecution());
    }

    protected void createVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new ActivitiException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    @Override
    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityExecution());
    }

    protected void removeVariable(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityExecution());
    }

    protected ExecutionEntity getSourceActivityExecution() {
        return null;
    }

    protected void removeVariableLocal(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            this.deleteVariableInstanceForExplicitUserCall(variableInstance, sourceActivityExecution);
            this.variableInstanceList.remove(variableInstance);
        }
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance, ExecutionEntity sourceActivityExecution) {
        variableInstance.delete();
        variableInstance.setValue(null);
        Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        if (variableInstance != null && !variableInstance.getType().isAbleToStore(value)) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            VariableType newType = variableTypes.findVariableType(value);
            variableInstance.setValue(null);
            variableInstance.setType(newType);
            variableInstance.forceUpdate();
            variableInstance.setValue(value);
            VariableInstanceEntity.touch(variableInstance);
        } else {
            variableInstance.setValue(value);
        }
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        this.variableInstances.put(variableName, variableInstance);
        this.variableInstanceList.add(variableInstance);
        Context.getCommandContext().getHistoryManager().recordVariableCreate(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        return variableInstance;
    }

    protected boolean isActivityIdUsedForDetails() {
        return true;
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

