/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.task.Comment;
import org.apache.commons.lang3.StringUtils;

public class GetProcessInstanceCommentsCmd
implements Command<List<Comment>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String type;

    public GetProcessInstanceCommentsCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetProcessInstanceCommentsCmd(String processInstanceId, String type) {
        this.processInstanceId = processInstanceId;
        this.type = type;
    }

    @Override
    public List<Comment> execute(CommandContext commandContext) {
        if (StringUtils.isNotBlank((CharSequence)this.type)) {
            List<Comment> commentsByProcessInstanceId = commandContext.getCommentEntityManager().findCommentsByProcessInstanceId(this.processInstanceId, this.type);
            return commentsByProcessInstanceId;
        }
        return commandContext.getCommentEntityManager().findCommentsByProcessInstanceId(this.processInstanceId);
    }
}

