/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.notify;

import java.util.concurrent.LinkedBlockingQueue;
import org.smslib.Service;
import org.smslib.helper.Logger;
import org.smslib.notify.CallNotification;
import org.smslib.notify.GatewayStatusNotification;
import org.smslib.notify.InboundMessageNotification;
import org.smslib.notify.Notification;
import org.smslib.notify.OutboundMessageNotification;
import org.smslib.threading.AServiceThread;

public class NotifyQueueManager {
    NotificationQueueManager notificationQueueManager;
    LinkedBlockingQueue<Notification> notifyQueue;

    public NotifyQueueManager() {
        this.setNotifyQueue(new LinkedBlockingQueue<Notification>());
    }

    public void start() {
        this.setNotifyQueueManager(new NotificationQueueManager("NotifyQueueManager", 100));
    }

    public void cancel() {
        int counter = 0;
        int prevSize = 0;
        while (this.getNotifyQueue().size() != 0) {
            if (prevSize != this.getNotifyQueue().size()) {
                prevSize = this.getNotifyQueue().size();
                counter = 0;
            } else if (prevSize == this.getNotifyQueue().size() && counter == 25) break;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++counter;
        }
        this.getNotifyQueueManager().cancel();
    }

    public LinkedBlockingQueue<Notification> getNotifyQueue() {
        return this.notifyQueue;
    }

    public void setNotifyQueue(LinkedBlockingQueue<Notification> notifyQueue) {
        this.notifyQueue = notifyQueue;
    }

    protected NotificationQueueManager getNotifyQueueManager() {
        return this.notificationQueueManager;
    }

    protected void setNotifyQueueManager(NotificationQueueManager notifyQueueManager) {
        this.notificationQueueManager = notifyQueueManager;
    }

    class NotificationQueueManager
    extends AServiceThread {
        public NotificationQueueManager(String name, int delay) {
            super(name, delay, 0, true);
        }

        @Override
        public void process() throws Exception {
            Logger.getInstance().logDebug("NotifyQueueManager running...", null, null);
            Notification notification = NotifyQueueManager.this.getNotifyQueue().take();
            if (notification instanceof GatewayStatusNotification) {
                if (Service.getInstance().getGatewayStatusNotification() != null) {
                    GatewayStatusNotification n = (GatewayStatusNotification)notification;
                    Service.getInstance().getGatewayStatusNotification().process(n.getGateway(), n.getOldStatus(), n.getNewStatus());
                }
            } else if (notification instanceof CallNotification) {
                if (Service.getInstance().getCallNotification() != null) {
                    CallNotification n = (CallNotification)notification;
                    Service.getInstance().getCallNotification().process(n.getGateway(), n.getCallerId());
                }
            } else if (notification instanceof InboundMessageNotification) {
                if (Service.getInstance().getInboundMessageNotification() != null) {
                    InboundMessageNotification n = (InboundMessageNotification)notification;
                    Service.getInstance().getInboundMessageNotification().process(n.getGateway(), n.getMsgType(), n.getMsg());
                }
            } else if (notification instanceof OutboundMessageNotification && Service.getInstance().getOutboundMessageNotification() != null) {
                OutboundMessageNotification n = (OutboundMessageNotification)notification;
                Service.getInstance().getOutboundMessageNotification().process(n.getGateway(), n.getMsg());
            }
            Logger.getInstance().logDebug("NotifyQueueManager end...", null, null);
        }
    }
}

