/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.jasig.services.persondir.support.ICurrentUserProvider;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.springframework.beans.factory.annotation.Required;

public class AdditionalDescriptorsPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private IPersonAttributes descriptors;
    private ICurrentUserProvider currentUserProvider;

    @Required
    public void setDescriptors(IPersonAttributes descriptors) {
        if (descriptors == null) {
            String msg = "Argument 'descriptors' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.descriptors = descriptors;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoking setDescriptors(" + descriptors + ")"));
        }
    }

    public ICurrentUserProvider getCurrentUserProvider() {
        return this.currentUserProvider;
    }

    public void setCurrentUserProvider(ICurrentUserProvider currentUserProvider) {
        this.currentUserProvider = currentUserProvider;
    }

    public Set<String> getAvailableQueryAttributes() {
        IUsernameAttributeProvider usernameAttributeProvider = super.getUsernameAttributeProvider();
        return Collections.singleton(usernameAttributeProvider.getUsernameAttribute());
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        IUsernameAttributeProvider usernameAttributeProvider;
        String uid;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoking getPeopleWithMultivaluedAttributes(" + query + ")"));
        }
        if ((uid = (usernameAttributeProvider = super.getUsernameAttributeProvider()).getUsernameFromQuery(query)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No username attribute found in query, returning null");
            }
            return null;
        }
        String targetName = this.descriptors.getName();
        if (targetName == null) {
            if (this.currentUserProvider != null) {
                targetName = this.currentUserProvider.getCurrentUserName();
            }
            if (targetName == null) {
                this.logger.warn((Object)("AdditionalDescriptors has a null name and a null name was returned by the currentUserProvider, returning null. " + this.descriptors));
                return null;
            }
        }
        if (uid.equals(targetName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding additional descriptors " + this.descriptors));
            }
            CaseInsensitiveNamedPersonImpl personAttributes = new CaseInsensitiveNamedPersonImpl(targetName, this.descriptors.getAttributes());
            return Collections.singleton(personAttributes);
        }
        return null;
    }

    public Set<String> getPossibleUserAttributeNames() {
        return null;
    }
}

