/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.ComputeDistanceResult;
import com.supermap.analyst.spatialanalyst.ComputeDistanceResultInternal;
import com.supermap.analyst.spatialanalyst.ComputeDistanceType;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ProximityAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsPoint;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class ProximityAnalyst {
    private static transient Vector<SteppedListener> _$2;
    private static License _$1;

    private ProximityAnalyst() {
    }

    public static DatasetVector createThiessenPolygon(DatasetVector datasetVector, Datasource datasource, String string, GeoRegion geoRegion) {
        ProximityAnalyst._$1();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (datasetVector == null || l == 0L) {
            String string2 = InternalResource.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string3 = InternalResource.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (datasource == null || l2 == 0L) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l3 = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygon(l, l2, string, l3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static DatasetVector createThiessenPolygon(Recordset recordset, Datasource datasource, String string, GeoRegion geoRegion) {
        ProximityAnalyst._$1();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (recordset == null || l == 0L) {
            String string2 = InternalResource.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string3 = InternalResource.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (datasource == null || l2 == 0L) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l3 = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        long l4 = ProximityAnalystNative.jni_CreateThiessenPolygonByRecordset(l, l2, string, l3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector createThiessenPolygon(Point2Ds point2Ds, Datasource datasource, String string, GeoRegion geoRegion) {
        ProximityAnalyst._$1();
        if (point2Ds == null || point2Ds.getCount() == 0) {
            String string2 = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (datasource == null || l == 0L) {
            String string3 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        long l2 = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l3 = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2Ds(dArray, dArray2, l, string, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoRegion[] createThiessenPolygon(DatasetVector datasetVector, GeoRegion geoRegion) {
        ProximityAnalyst._$1();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (datasetVector == null || l == 0L) {
            String string = InternalResource.loadString("sourcePoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResource.loadString("sourcePoint", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        GeoRegion[] geoRegionArray = ProximityAnalyst.createThiessenPolygon(recordset, geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        recordset.dispose();
        return geoRegionArray;
    }

    public static GeoRegion[] createThiessenPolygon(Recordset recordset, GeoRegion geoRegion) {
        String string;
        ProximityAnalyst._$1();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (recordset == null || l == 0L) {
            String string2 = InternalResource.loadString("sourcePointRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (!recordset.getDataset().getType().equals((Object)DatasetType.POINT)) {
            String string3 = InternalResource.loadString("sourcePointRecordset", "ProximityAnalystNotPointType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        Datasource datasource = recordset.getDataset().getDatasource();
        DatasetVector datasetVector = ProximityAnalyst.createThiessenPolygon(recordset, datasource, string = datasource.getDatasets().getAvailableDatasetName("name"), geoRegion);
        if (datasetVector == null) {
            return new GeoRegion[0];
        }
        ArrayList<GeoRegion> arrayList = new ArrayList<GeoRegion>();
        Recordset recordset2 = datasetVector.getRecordset(false, CursorType.STATIC);
        recordset2.moveFirst();
        while (!recordset2.isEOF()) {
            GeoRegion geoRegion2 = (GeoRegion)recordset2.getGeometry();
            arrayList.add(geoRegion2);
            recordset2.moveNext();
        }
        int n = arrayList.size();
        GeoRegion[] geoRegionArray = new GeoRegion[n];
        for (int i = 0; i < n; ++i) {
            geoRegionArray[i] = (GeoRegion)arrayList.get(i);
        }
        recordset2.dispose();
        datasource.getDatasets().delete(datasetVector.getName());
        return geoRegionArray;
    }

    public static GeoRegion[] createThiessenPolygon(Point2Ds point2Ds, GeoRegion geoRegion) {
        ProximityAnalyst._$1();
        if (point2Ds == null || point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (geoRegion != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) != 0L) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        }
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long[] lArray = ProximityAnalystNative.jni_CreateThiessPolygonByPoints2DsSecond(dArray, dArray2, l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        GeoRegion[] geoRegionArray = null;
        if (lArray == null) {
            geoRegionArray = new GeoRegion[]{};
        } else {
            int n2 = lArray.length;
            geoRegionArray = new GeoRegion[n2];
            for (int i = 0; i < n2; ++i) {
                geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
            }
        }
        return geoRegionArray;
    }

    public static boolean computeMinDistance(Recordset recordset, Recordset recordset2, double d, double d2, Datasource datasource, String string) {
        return ProximityAnalyst._$1(recordset, recordset2, d, d2, datasource, string, ComputeDistanceType.MINDISTANCE);
    }

    public static boolean computeMinDistance(Geometry[] geometryArray, Recordset recordset, double d, double d2, Datasource datasource, String string) {
        return ProximityAnalyst._$1(geometryArray, recordset, d, d2, datasource, string, ComputeDistanceType.MINDISTANCE);
    }

    public static ComputeDistanceResult[] computeMinDistance(Recordset recordset, Recordset recordset2, double d, double d2) {
        return ProximityAnalyst._$2(recordset, recordset2, d, d2, ComputeDistanceType.MINDISTANCE);
    }

    public static ComputeDistanceResult[] computeMinDistance(Geometry[] geometryArray, Recordset recordset, double d, double d2) {
        return ProximityAnalyst._$2(geometryArray, recordset, d, d2, ComputeDistanceType.MINDISTANCE);
    }

    public static boolean computeRangeDistance(Recordset recordset, Recordset recordset2, double d, double d2, Datasource datasource, String string) {
        return ProximityAnalyst._$1(recordset, recordset2, d, d2, datasource, string, ComputeDistanceType.RANGEDISTANCE);
    }

    public static boolean computeRangeDistance(Geometry[] geometryArray, Recordset recordset, double d, double d2, Datasource datasource, String string) {
        return ProximityAnalyst._$1(geometryArray, recordset, d, d2, datasource, string, ComputeDistanceType.RANGEDISTANCE);
    }

    public static ComputeDistanceResult[] computeRangeDistance(Recordset recordset, Recordset recordset2, double d, double d2) {
        return ProximityAnalyst._$2(recordset, recordset2, d, d2, ComputeDistanceType.RANGEDISTANCE);
    }

    public static ComputeDistanceResult[] computeRangeDistance(Geometry[] geometryArray, Recordset recordset, double d, double d2) {
        return ProximityAnalyst._$2(geometryArray, recordset, d, d2, ComputeDistanceType.RANGEDISTANCE);
    }

    private static boolean _$1(Recordset recordset, Recordset recordset2, double d, double d2, Datasource datasource, String string, ComputeDistanceType computeDistanceType) {
        ProximityAnalyst._$1(recordset, recordset2, d, d2, computeDistanceType);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset)};
        if (datasource == null) {
            String string2 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string3 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string == null) {
            String string4 = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(string);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset2);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n, bl, l3, l2, d, d2, computeDistanceType.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset2);
        if (!bl2) {
            datasource.getDatasets().delete(string);
        }
        return bl2;
    }

    private static boolean _$1(Geometry[] geometryArray, Recordset recordset, double d, double d2, Datasource datasource, String string, ComputeDistanceType computeDistanceType) {
        boolean bl;
        ProximityAnalyst._$1(geometryArray, recordset, d, d2, computeDistanceType);
        int n = 0;
        for (bl = false; bl < geometryArray.length; bl += 1) {
            if (geometryArray[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string2 = InternalResource.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i] == null) continue;
            if (geometryArray[i].getType() != GeometryType.GEOPOINT) {
                String string3 = InternalResource.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
            lArray[n3++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryArray[i]);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string5 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (string == null) {
            String string6 = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string6);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string7 = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(string);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector == null) {
            return false;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        boolean bl2 = ProximityAnalystNative.jni_ComputeDistance(lArray, n2, bl, l3, l2, d, d2, computeDistanceType.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometryArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        if (!bl2) {
            datasource.getDatasets().delete(string);
        }
        return bl2;
    }

    private static ComputeDistanceResult[] _$2(Recordset recordset, Recordset recordset2, double d, double d2, ComputeDistanceType computeDistanceType) {
        ProximityAnalyst._$1(recordset, recordset2, d, d2, computeDistanceType);
        int n = 1;
        boolean bl = false;
        long[] lArray = new long[]{InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset)};
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset2);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n, bl, l, d, d2, computeDistanceType.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset2);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            ComputeDistanceResultInternal computeDistanceResultInternal = new ComputeDistanceResultInternal(lArray2[i]);
            if (computeDistanceResultInternal.getSourceGeometryID() < 0) {
                computeDistanceResultInternal.dispose();
                continue;
            }
            double d3 = computeDistanceResultInternal.getDistance();
            int[] nArray = computeDistanceResultInternal.getReferenceGeometryIDs();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(computeDistanceResultInternal.getSourceGeometryID());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d3);
            computeDistanceResultArray[i] = computeDistanceResult;
            computeDistanceResultInternal.dispose();
        }
        return computeDistanceResultArray;
    }

    private static ComputeDistanceResult[] _$2(Geometry[] geometryArray, Recordset recordset, double d, double d2, ComputeDistanceType computeDistanceType) {
        boolean bl;
        ProximityAnalyst._$1(geometryArray, recordset, d, d2, computeDistanceType);
        int n = 0;
        for (bl = false; bl < geometryArray.length; bl += 1) {
            if (geometryArray[bl] == null) continue;
            ++n;
        }
        if (n == 0) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        int n2 = n;
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < geometryArray.length; ++i) {
            if (geometryArray[i] == null) continue;
            if (geometryArray[i].getType() != GeometryType.GEOPOINT) {
                String string = InternalResource.loadString("sourceGeometries", "GeometryTypeMustBePoint", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[n3++] = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryArray[i]);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long[] lArray2 = ProximityAnalystNative.jni_ComputeDistance1(lArray, n2, bl, l, d, d2, computeDistanceType.value());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometryArray);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        if (lArray2 == null || lArray2.length == 0) {
            return null;
        }
        ComputeDistanceResult[] computeDistanceResultArray = new ComputeDistanceResult[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            ComputeDistanceResultInternal computeDistanceResultInternal = new ComputeDistanceResultInternal(lArray2[i]);
            if (computeDistanceResultInternal.getSourceGeometryID() < 0) {
                computeDistanceResultInternal.dispose();
                continue;
            }
            double d3 = computeDistanceResultInternal.getDistance();
            int[] nArray = computeDistanceResultInternal.getReferenceGeometryIDs();
            ComputeDistanceResult computeDistanceResult = new ComputeDistanceResult();
            computeDistanceResult.setSourceGeometryID(computeDistanceResultInternal.getSourceGeometryID());
            computeDistanceResult.setReferenceGeometryIDs(nArray);
            computeDistanceResult.setDistance(d3);
            computeDistanceResultArray[i] = computeDistanceResult;
            computeDistanceResultInternal.dispose();
        }
        return computeDistanceResultArray;
    }

    private static boolean _$1(Geometry[] geometryArray, Recordset recordset, double d, double d2, ComputeDistanceType computeDistanceType) {
        if (recordset == null) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = recordset.getDataset().getType();
        if (datasetType != DatasetType.POINT && datasetType != DatasetType.LINE && datasetType != DatasetType.REGION && datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType == DatasetType.NETWORK && recordset.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            d2 = -1.0;
        }
        if (computeDistanceType == ComputeDistanceType.MINDISTANCE && d2 == 0.0) {
            String string = InternalResource.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (computeDistanceType == ComputeDistanceType.RANGEDISTANCE && d2 <= 0.0) {
            String string = InternalResource.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 > 0.0 && d2 < d) {
            String string = InternalResource.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        return true;
    }

    private static boolean _$1(Recordset recordset, Recordset recordset2, double d, double d2, ComputeDistanceType computeDistanceType) {
        if (recordset2 == null) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset2);
        if (l == 0L) {
            String string = InternalResource.loadString("referenceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("minDistance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            d2 = -1.0;
        }
        if (computeDistanceType == ComputeDistanceType.MINDISTANCE && d2 == 0.0) {
            String string = InternalResource.loadString("maxDistance", "CanNotBeZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (computeDistanceType == ComputeDistanceType.RANGEDISTANCE && d2 <= 0.0) {
            String string = InternalResource.loadString("maxDistance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 > 0.0 && d2 < d) {
            String string = InternalResource.loadString("maxDistance", "MaxDistance_CannotBeLess_MinDistance", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = recordset.getDataset().getType();
        if (datasetType != DatasetType.POINT) {
            String string = InternalResource.loadString("sourceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType2 = recordset2.getDataset().getType();
        if (datasetType2 != DatasetType.POINT && datasetType2 != DatasetType.LINE && datasetType2 != DatasetType.REGION && datasetType2 != DatasetType.NETWORK) {
            String string = InternalResource.loadString("referenceRecordset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetType2 == DatasetType.NETWORK && recordset2.getDataset().getChildDataset().getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("referenceRecordset", "Unsupport_3D_DatasetVector", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSys prjCoordSys = recordset.getDataset().getPrjCoordSys();
        PrjCoordSys prjCoordSys2 = recordset2.getDataset().getPrjCoordSys();
        if (prjCoordSys.toXML().compareToIgnoreCase(prjCoordSys2.toXML()) != 0) {
            String string = InternalResource.loadString("sourceRecordset and referenceRecordset", "Projection_Not_Same", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public static DatasetVector rarefyPoints(DatasetVector datasetVector, double d, String string, Datasource datasource) {
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string3 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l2 == 0L) {
            String string5 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (string == null || string.isEmpty()) {
            String string6 = InternalResource.loadString("resultDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (d < 0.0 || d == 0.0) {
            String string7 = InternalResource.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (datasetVector.getType() != DatasetType.POINT) {
            String string8 = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(datasource.getDatasets().getAvailableDatasetName(string));
        datasetVectorInfo.setType(datasetVector.getType());
        DatasetVector datasetVector2 = datasource.getDatasets().create(datasetVectorInfo);
        if (datasetVector2 == null) {
            return null;
        }
        datasetVector2.open();
        datasetVector2.setPrjCoordSys(datasetVector.getPrjCoordSys());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
        boolean bl = false;
        bl = ProximityAnalystNative.jni_RarefyDt(l, l3, d);
        if (bl) {
            return datasetVector2;
        }
        datasource.getDatasets().delete(datasetVector2.getName());
        return null;
    }

    public static StatisticsPoint[] rarefyPoints(StatisticsPoint[] statisticsPointArray, double d) {
        if (statisticsPointArray == null) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (statisticsPointArray.length == 0) {
            String string = InternalResource.loadString("sourcePoints", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0 || d == 0.0) {
            String string = InternalResource.loadString("radius", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = statisticsPointArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (statisticsPointArray[i].getPoint() != null) {
                dArray[i] = statisticsPointArray[i].getPoint().getX();
                dArray2[i] = statisticsPointArray[i].getPoint().getY();
                nArray[i] = statisticsPointArray[i].getStatisticsCount();
                continue;
            }
            nArray[i] = 0;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int[] nArray2 = new int[n];
        int n2 = ProximityAnalystNative.jni_RarefyDt2(dArray, dArray2, nArray, n, d, dArray3, dArray4, nArray2);
        if (n2 > 0) {
            StatisticsPoint[] statisticsPointArray2 = new StatisticsPoint[n2];
            for (int i = 0; i < n2; ++i) {
                statisticsPointArray2[i] = new StatisticsPoint(new Point2D(dArray3[i], dArray4[i]), nArray2[i]);
            }
            return statisticsPointArray2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$1;
        synchronized (object) {
            n = _$1.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector<SteppedListener> vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "ProximityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        ProximityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$1 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

