/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.DensityAnalystNative;
import com.supermap.analyst.spatialanalyst.DensityAnalystParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Vector;

public class DensityAnalyst {
    private static License _$2;
    private static transient Vector _$1;

    private DensityAnalyst() {
    }

    public static DatasetGrid kernelDensity(DensityAnalystParameter densityAnalystParameter, DatasetVector datasetVector, String string, Datasource datasource, String string2) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string3 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = DensityAnalyst._$1(densityAnalystParameter, recordset, string, datasource, string2);
        recordset.dispose();
        return datasetGrid;
    }

    private static DatasetGrid _$1(DensityAnalystParameter densityAnalystParameter, Recordset recordset, String string, Datasource datasource, String string2) {
        String string3;
        DensityAnalyst._$1();
        if (recordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset) == 0L) {
            String string4 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        DatasetVector datasetVector = recordset.getDataset();
        if (string != null && !string.isEmpty()) {
            if (recordset.getFieldInfos().indexOf(string) == -1) {
                String string5 = InternalResource.loadString("valueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            string3 = recordset.getFieldInfos().get(string);
            if (string3 == null || string3.getType() != FieldType.DOUBLE && string3.getType() != FieldType.INT16 && string3.getType() != FieldType.INT32 && string3.getType() != FieldType.INT64 && string3.getType() != FieldType.SINGLE) {
                String string6 = InternalResource.loadString("valueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            string3 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
            string3 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = densityAnalystParameter.getBounds().isEmpty();
        if (bl) {
            densityAnalystParameter.setBounds(datasetVector.getBounds());
        }
        boolean bl2 = false;
        double d = densityAnalystParameter.getResolution();
        if (Toolkit.isZero((double)densityAnalystParameter.getResolution()) || densityAnalystParameter.getResolution() < 0.0) {
            bl2 = true;
            double d2 = Math.min(densityAnalystParameter.getBounds().getHeight(), densityAnalystParameter.getBounds().getWidth());
            densityAnalystParameter.setResolution(d2 / 500.0);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)densityAnalystParameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l4 = DensityAnalystNative.jni_KernelDensity(l, l2, string, l3, string2);
        if (bl) {
            densityAnalystParameter.setBounds(Rectangle2D.getEMPTY());
        }
        if (bl2) {
            densityAnalystParameter.setResolution(d);
        }
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)densityAnalystParameter));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return datasetGrid;
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        DensityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

