/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.resolver;

import com.googlecode.ehcache.annotations.CacheNotFoundException;
import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.DecoratedCacheType;
import com.googlecode.ehcache.annotations.RefreshingCacheEntryFactory;
import com.googlecode.ehcache.annotations.RefreshingSelfPopulatingCache;
import com.googlecode.ehcache.annotations.SelfPopulatingCacheScope;
import com.googlecode.ehcache.annotations.TriggersRemove;
import com.googlecode.ehcache.annotations.resolver.CacheResolverFactory;
import com.googlecode.ehcache.annotations.resolver.CacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.SingletonCacheableCacheResolver;
import com.googlecode.ehcache.annotations.resolver.SingletonTriggersRemoveCacheResolver;
import com.googlecode.ehcache.annotations.resolver.ThreadLocalCacheEntryFactory;
import com.googlecode.ehcache.annotations.resolver.TriggersRemoveCacheResolver;
import com.googlecode.ehcache.annotations.support.TaskSchedulerAdapter;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.util.ProductInfo;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.StringUtils;

public class DefaultCacheResolverFactory
implements CacheResolverFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean badSelfPopulatingCache;
    private final ConcurrentMap<String, SelfPopulatingCacheTracker> selfPopulatingCaches = new ConcurrentHashMap<String, SelfPopulatingCacheTracker>();
    private final CacheManager cacheManager;
    private boolean createCaches = false;
    private SelfPopulatingCacheScope selfPopulatingCacheScope = SelfPopulatingCacheScope.SHARED;
    private TaskSchedulerAdapter scheduler;
    private SchedulingTaskExecutor executor;

    public DefaultCacheResolverFactory(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        ProductInfo productInfo = new ProductInfo();
        String version = productInfo.getVersion();
        this.badSelfPopulatingCache = version.equals("2.3.0") || version.equals("2.3.1");
    }

    public void setScheduler(TaskSchedulerAdapter scheduler) {
        this.scheduler = scheduler;
    }

    public void setExecutor(SchedulingTaskExecutor executor) {
        this.executor = executor;
    }

    public boolean isCreateCaches() {
        return this.createCaches;
    }

    public void setCreateCaches(boolean createCaches) {
        this.createCaches = createCaches;
    }

    public void setSelfPopulatingCacheScope(SelfPopulatingCacheScope selfPopulatingCacheScope) {
        this.selfPopulatingCacheScope = selfPopulatingCacheScope;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CacheableCacheResolver getCacheResolver(Cacheable cacheable, Method method) {
        String exceptionCacheName;
        String cacheName = cacheable.cacheName();
        Ehcache cache = this.getCache(cacheName);
        ThreadLocal<MethodInvocation> entryFactory = null;
        DecoratedCacheType decoratedCacheType = DecoratedCacheType.getDecoratedCacheType(cacheable, method);
        if (decoratedCacheType == DecoratedCacheType.SELF_POPULATING_CACHE || decoratedCacheType == DecoratedCacheType.REFRESHING_SELF_POPULATING_CACHE) {
            if (this.badSelfPopulatingCache) {
                this.logger.error("SelfPopulatingCache in Ehcache 2.3.0 & 2.3.1 has a bug which can result in unexpected behavior, see EHC-828. {} may not behave as expected", (Object)cacheName);
            }
            int selfPopulatingTimeout = cacheable.selfPopulatingTimeout();
            long refreshInterval = cacheable.refreshInterval();
            SelfPopulatingCacheTracker selfPopulatingCacheTracker = this.createSelfPopulatingCacheInternal(cache, selfPopulatingTimeout, decoratedCacheType, refreshInterval);
            cache = selfPopulatingCacheTracker.selfPopulatingCache;
            entryFactory = selfPopulatingCacheTracker.cacheEntryFactory;
        }
        if (StringUtils.hasLength((String)(exceptionCacheName = cacheable.exceptionCacheName()))) {
            Ehcache exceptionCache = this.getCache(exceptionCacheName);
            return new SingletonCacheableCacheResolver(cache, entryFactory, exceptionCache);
        }
        return new SingletonCacheableCacheResolver(cache, entryFactory);
    }

    public TriggersRemoveCacheResolver getCacheResolver(TriggersRemove triggersRemove, Method method) {
        String[] cacheNames = triggersRemove.cacheName();
        LinkedHashSet<Ehcache> caches = new LinkedHashSet<Ehcache>(cacheNames.length);
        for (String cacheName : cacheNames) {
            Ehcache cache = this.getCache(cacheName);
            caches.add(cache);
        }
        return new SingletonTriggersRemoveCacheResolver(caches);
    }

    protected Ehcache getCache(String cacheName) {
        CacheManager cacheManager = this.getCacheManager();
        Ehcache cache = cacheManager.getEhcache(cacheName);
        if (cache == null) {
            if (this.createCaches) {
                this.logger.warn("No cache named '{}' exists, it will be created from the defaultCache", (Object)cacheName);
                try {
                    cacheManager.addCache(cacheName);
                }
                catch (ObjectExistsException oee) {
                    this.logger.trace("Race condition creating missing cache '{}', ignoring and retrieving existing cache", (Object)cacheName);
                }
                cache = cacheManager.getEhcache(cacheName);
            } else {
                throw new CacheNotFoundException(cacheName);
            }
        }
        return cache;
    }

    protected final SelfPopulatingCacheTracker createSelfPopulatingCacheInternal(Ehcache cache, int timeout, DecoratedCacheType type, long refreshinterval) {
        int timeoutMillis;
        if (SelfPopulatingCacheScope.METHOD == this.selfPopulatingCacheScope) {
            return this.createSelfPopulatingCache(cache, timeout, type, refreshinterval);
        }
        boolean newCache = false;
        String cacheName = cache.getName();
        SelfPopulatingCacheTracker selfPopulatingCacheTracker = (SelfPopulatingCacheTracker)this.selfPopulatingCaches.get(cacheName);
        if (selfPopulatingCacheTracker == null) {
            selfPopulatingCacheTracker = this.createSelfPopulatingCache(cache, timeout, type, refreshinterval);
            SelfPopulatingCacheTracker existing = this.selfPopulatingCaches.putIfAbsent(cacheName, selfPopulatingCacheTracker);
            if (existing != null) {
                selfPopulatingCacheTracker = existing;
            } else {
                newCache = true;
            }
        }
        if (!newCache && (timeoutMillis = selfPopulatingCacheTracker.selfPopulatingCache.getTimeoutMillis()) != timeout) {
            this.logger.warn("SelfPopulatingCache " + cacheName + " was already created by another annotation but has a different timeout of " + timeoutMillis + ". The timeout " + timeout + " for the current annotation will be ignored.", new Throwable());
        }
        return selfPopulatingCacheTracker;
    }

    protected SelfPopulatingCacheTracker createSelfPopulatingCache(Ehcache cache, int timeout, DecoratedCacheType type, long refreshinterval) {
        ThreadLocal invocationLocal;
        SelfPopulatingCache selfPopulatingCache;
        switch (type) {
            case REFRESHING_SELF_POPULATING_CACHE: {
                RefreshingCacheEntryFactory cacheEntryFactory = new RefreshingCacheEntryFactory();
                selfPopulatingCache = new RefreshingSelfPopulatingCache(cache, cacheEntryFactory, this.scheduler, (TaskExecutor)this.executor, refreshinterval);
                invocationLocal = cacheEntryFactory.entryFactory;
                break;
            }
            case SELF_POPULATING_CACHE: {
                ThreadLocalCacheEntryFactory cacheEntryFactory = new ThreadLocalCacheEntryFactory();
                selfPopulatingCache = new SelfPopulatingCache(cache, (CacheEntryFactory)cacheEntryFactory);
                invocationLocal = cacheEntryFactory.entryFactory;
                break;
            }
            default: {
                throw new IllegalArgumentException("DecoratedCacheType " + (Object)((Object)type) + " is not a supported self-populating type");
            }
        }
        selfPopulatingCache.setTimeoutMillis(timeout);
        return new SelfPopulatingCacheTracker(selfPopulatingCache, invocationLocal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SelfPopulatingCacheTracker {
        public final SelfPopulatingCache selfPopulatingCache;
        public final ThreadLocal<MethodInvocation> cacheEntryFactory;

        public SelfPopulatingCacheTracker(SelfPopulatingCache selfPopulatingCache, ThreadLocal<MethodInvocation> cacheEntryFactory) {
            this.selfPopulatingCache = selfPopulatingCache;
            this.cacheEntryFactory = cacheEntryFactory;
        }
    }
}

