/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.NullSetEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.log.LogManager;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.StringUtils;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.UberspectLoggable;

public class RuntimeInstance
implements RuntimeConstants,
RuntimeServices {
    private VelocimacroFactory vmFactory = null;
    private Log log = new Log();
    private ParserPool parserPool;
    private boolean initializing = false;
    private boolean initialized = false;
    private ExtendedProperties overridingProperties = null;
    private Hashtable runtimeDirectives;
    private ExtendedProperties configuration = new ExtendedProperties();
    private ResourceManager resourceManager = null;
    private EventCartridge eventCartridge = null;
    private Introspector introspector = null;
    private Map applicationAttributes = null;
    private Uberspect uberSpect;
    static /* synthetic */ Class class$org$apache$velocity$util$introspection$Uberspect;
    static /* synthetic */ Class class$org$apache$velocity$runtime$resource$ResourceManager;
    static /* synthetic */ Class class$org$apache$velocity$app$event$ReferenceInsertionEventHandler;
    static /* synthetic */ Class class$org$apache$velocity$app$event$NullSetEventHandler;
    static /* synthetic */ Class class$org$apache$velocity$app$event$MethodExceptionEventHandler;
    static /* synthetic */ Class class$org$apache$velocity$app$event$IncludeEventHandler;
    static /* synthetic */ Class class$org$apache$velocity$app$event$InvalidReferenceEventHandler;
    static /* synthetic */ Class class$org$apache$velocity$runtime$directive$Directive;
    static /* synthetic */ Class class$org$apache$velocity$runtime$ParserPool;

    public RuntimeInstance() {
        this.vmFactory = new VelocimacroFactory(this);
        this.introspector = new Introspector(this.getLog());
        this.applicationAttributes = new HashMap();
    }

    public synchronized void init() throws Exception {
        if (!this.initialized && !this.initializing) {
            this.initializing = true;
            this.log.trace("*******************************************************************");
            this.log.debug("Starting Apache Velocity v1.5 (compiled: 2007-02-22 08:52:29)");
            this.log.trace("RuntimeInstance initializing.");
            this.initializeProperties();
            this.initializeLog();
            this.initializeResourceManager();
            this.initializeDirectives();
            this.initializeEventHandlers();
            this.initializeParserPool();
            this.initializeIntrospection();
            this.vmFactory.initVelocimacro();
            this.log.trace("RuntimeInstance successfully initialized.");
            this.initialized = true;
            this.initializing = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void initializeIntrospection() throws Exception {
        String rm = this.getString("runtime.introspector.uberspect");
        if (rm != null && rm.length() > 0) {
            Object o = null;
            try {
                o = ClassUtils.getNewInstance(rm);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for Uberspect (" + rm + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof Uberspect)) {
                String err = "The specified class for Uberspect (" + rm + ") does not implement " + (class$org$apache$velocity$util$introspection$Uberspect == null ? (class$org$apache$velocity$util$introspection$Uberspect = RuntimeInstance.class$("org.apache.velocity.util.introspection.Uberspect")) : class$org$apache$velocity$util$introspection$Uberspect).getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new Exception(err);
            }
            this.uberSpect = (Uberspect)o;
            if (this.uberSpect instanceof UberspectLoggable) {
                ((UberspectLoggable)((Object)this.uberSpect)).setLog(this.getLog());
            }
            if (this.uberSpect instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)((Object)this.uberSpect)).setRuntimeServices(this);
            }
        } else {
            String err = "It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.";
            this.log.error(err);
            throw new Exception(err);
        }
        this.uberSpect.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setDefaultProperties() {
        block12: {
            InputStream inputStream;
            block11: {
                inputStream = null;
                inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/velocity.properties");
                this.configuration.load(inputStream);
                if (!this.log.isDebugEnabled()) break block11;
                this.log.debug("Default Properties File: " + new File("org/apache/velocity/runtime/defaults/velocity.properties").getPath());
            }
            Object var4_2 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block12;
            }
            catch (IOException ioe2) {
                this.log.error("Cannot close Velocity Runtime default properties!", ioe2);
            }
            break block12;
            {
                catch (IOException ioe) {
                    this.log.error("Cannot get Velocity Runtime default properties!", ioe);
                    Object var4_3 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block12;
                    }
                    catch (IOException ioe2) {
                        this.log.error("Cannot close Velocity Runtime default properties!", ioe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ioe2) {
                    this.log.error("Cannot close Velocity Runtime default properties!", ioe2);
                }
                throw throwable;
            }
        }
    }

    public void setProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.setProperty(key, value);
    }

    public void setConfiguration(ExtendedProperties configuration) {
        if (this.overridingProperties == null) {
            this.overridingProperties = configuration;
        } else if (this.overridingProperties != configuration) {
            this.overridingProperties.combine(configuration);
        }
    }

    public void addProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtendedProperties();
        }
        this.overridingProperties.addProperty(key, value);
    }

    public void clearProperty(String key) {
        if (this.overridingProperties != null) {
            this.overridingProperties.clearProperty(key);
        }
    }

    public Object getProperty(String key) {
        Object o = null;
        if (!this.initialized && !this.initializing && this.overridingProperties != null) {
            o = this.overridingProperties.get((Object)key);
        }
        if (o == null) {
            o = this.configuration.getProperty(key);
        }
        if (o instanceof String) {
            return StringUtils.nullTrim((String)o);
        }
        return o;
    }

    private void initializeProperties() {
        if (!this.configuration.isInitialized()) {
            this.setDefaultProperties();
        }
        if (this.overridingProperties != null) {
            this.configuration.combine(this.overridingProperties);
        }
    }

    public void init(Properties p) throws Exception {
        this.overridingProperties = ExtendedProperties.convertProperties((Properties)p);
        this.init();
    }

    public void init(String configurationFile) throws Exception {
        this.overridingProperties = new ExtendedProperties(configurationFile);
        this.init();
    }

    private void initializeResourceManager() throws Exception {
        Object o;
        String rm = this.getString("resource.manager.class");
        if (rm != null && rm.length() > 0) {
            o = null;
            try {
                o = ClassUtils.getNewInstance(rm);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ResourceManager (" + rm + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof ResourceManager)) {
                String err = "The specified class for ResourceManager (" + rm + ") does not implement " + (class$org$apache$velocity$runtime$resource$ResourceManager == null ? (class$org$apache$velocity$runtime$resource$ResourceManager = RuntimeInstance.class$("org.apache.velocity.runtime.resource.ResourceManager")) : class$org$apache$velocity$runtime$resource$ResourceManager).getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new Exception(err);
            }
        } else {
            String err = "It appears that no class was specified as the ResourceManager.  Please ensure that all configuration information is correct.";
            this.log.error(err);
            throw new Exception(err);
        }
        this.resourceManager = (ResourceManager)o;
        this.resourceManager.initialize(this);
    }

    private void initializeEventHandlers() throws Exception {
        String[] invalidReferenceSet;
        String[] includeHandler;
        String[] methodexception;
        String[] nullset;
        this.eventCartridge = new EventCartridge();
        String[] referenceinsertion = this.configuration.getStringArray("eventhandler.referenceinsertion.class");
        if (referenceinsertion != null) {
            for (int i = 0; i < referenceinsertion.length; ++i) {
                EventHandler ev = this.initializeSpecificEventHandler(referenceinsertion[i], "eventhandler.referenceinsertion.class", class$org$apache$velocity$app$event$ReferenceInsertionEventHandler == null ? RuntimeInstance.class$("org.apache.velocity.app.event.ReferenceInsertionEventHandler") : class$org$apache$velocity$app$event$ReferenceInsertionEventHandler);
                if (ev == null) continue;
                this.eventCartridge.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)ev);
            }
        }
        if ((nullset = this.configuration.getStringArray("eventhandler.nullset.class")) != null) {
            for (int i = 0; i < nullset.length; ++i) {
                EventHandler ev = this.initializeSpecificEventHandler(nullset[i], "eventhandler.nullset.class", class$org$apache$velocity$app$event$NullSetEventHandler == null ? RuntimeInstance.class$("org.apache.velocity.app.event.NullSetEventHandler") : class$org$apache$velocity$app$event$NullSetEventHandler);
                if (ev == null) continue;
                this.eventCartridge.addNullSetEventHandler((NullSetEventHandler)ev);
            }
        }
        if ((methodexception = this.configuration.getStringArray("eventhandler.methodexception.class")) != null) {
            for (int i = 0; i < methodexception.length; ++i) {
                EventHandler ev = this.initializeSpecificEventHandler(methodexception[i], "eventhandler.methodexception.class", class$org$apache$velocity$app$event$MethodExceptionEventHandler == null ? RuntimeInstance.class$("org.apache.velocity.app.event.MethodExceptionEventHandler") : class$org$apache$velocity$app$event$MethodExceptionEventHandler);
                if (ev == null) continue;
                this.eventCartridge.addMethodExceptionHandler((MethodExceptionEventHandler)ev);
            }
        }
        if ((includeHandler = this.configuration.getStringArray("eventhandler.include.class")) != null) {
            for (int i = 0; i < includeHandler.length; ++i) {
                EventHandler ev = this.initializeSpecificEventHandler(includeHandler[i], "eventhandler.include.class", class$org$apache$velocity$app$event$IncludeEventHandler == null ? RuntimeInstance.class$("org.apache.velocity.app.event.IncludeEventHandler") : class$org$apache$velocity$app$event$IncludeEventHandler);
                if (ev == null) continue;
                this.eventCartridge.addIncludeEventHandler((IncludeEventHandler)ev);
            }
        }
        if ((invalidReferenceSet = this.configuration.getStringArray("eventhandler.invalidreferences.class")) != null) {
            for (int i = 0; i < invalidReferenceSet.length; ++i) {
                EventHandler ev = this.initializeSpecificEventHandler(invalidReferenceSet[i], "eventhandler.invalidreferences.class", class$org$apache$velocity$app$event$InvalidReferenceEventHandler == null ? RuntimeInstance.class$("org.apache.velocity.app.event.InvalidReferenceEventHandler") : class$org$apache$velocity$app$event$InvalidReferenceEventHandler);
                if (ev == null) continue;
                this.eventCartridge.addInvalidReferenceEventHandler((InvalidReferenceEventHandler)ev);
            }
        }
    }

    private EventHandler initializeSpecificEventHandler(String classname, String paramName, Class EventHandlerInterface) throws Exception {
        if (classname != null && classname.length() > 0) {
            Object o = null;
            try {
                o = ClassUtils.getNewInstance(classname);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for " + paramName + " (" + classname + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new Exception(err);
            }
            if (!EventHandlerInterface.isAssignableFrom(EventHandlerInterface)) {
                String err = "The specified class for " + paramName + " (" + classname + ") does not implement " + EventHandlerInterface.getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new Exception(err);
            }
            EventHandler ev = (EventHandler)o;
            if (ev instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)((Object)ev)).setRuntimeServices(this);
            }
            return ev;
        }
        return null;
    }

    private void initializeLog() throws Exception {
        LogManager.updateLog(this.log, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeDirectives() throws Exception {
        Properties directiveProperties;
        block14: {
            this.runtimeDirectives = new Hashtable();
            directiveProperties = new Properties();
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/directive.properties");
            if (inputStream == null) {
                throw new Exception("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
            }
            directiveProperties.load(inputStream);
            Object var5_3 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block14;
            }
            catch (IOException ioe2) {
                this.log.error("Cannot close directive properties!", ioe2);
            }
            break block14;
            {
                catch (IOException ioe) {
                    this.log.error("Error while loading directive properties!", ioe);
                    var5_3 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException ioe2) {
                        this.log.error("Cannot close directive properties!", ioe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ioe2) {
                    this.log.error("Cannot close directive properties!", ioe2);
                }
                throw throwable;
            }
        }
        Enumeration<Object> directiveClasses = directiveProperties.elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            this.loadDirective(directiveClass);
            this.log.debug("Loaded System Directive: " + directiveClass);
        }
        String[] userdirective = this.configuration.getStringArray("userdirective");
        for (int i = 0; i < userdirective.length; ++i) {
            this.loadDirective(userdirective[i]);
            if (!this.log.isInfoEnabled()) continue;
            this.log.info("Loaded User Directive: " + userdirective[i]);
        }
    }

    private void loadDirective(String directiveClass) {
        try {
            Object o = ClassUtils.getNewInstance(directiveClass);
            if (o instanceof Directive) {
                Directive directive = (Directive)o;
                this.runtimeDirectives.put(directive.getName(), directive);
            } else {
                this.log.error(directiveClass + " does not implement " + (class$org$apache$velocity$runtime$directive$Directive == null ? (class$org$apache$velocity$runtime$directive$Directive = RuntimeInstance.class$("org.apache.velocity.runtime.directive.Directive")) : class$org$apache$velocity$runtime$directive$Directive).getName() + "; it cannot be loaded.");
            }
        }
        catch (Exception e) {
            this.log.error("Failed to load Directive: " + directiveClass, e);
        }
    }

    private void initializeParserPool() throws Exception {
        Object o;
        String pp = this.getString("parser.pool.class");
        if (pp != null && pp.length() > 0) {
            o = null;
            try {
                o = ClassUtils.getNewInstance(pp);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ParserPool (" + pp + ") does not exist (or is not accessible to the current classloader.";
                this.log.error(err);
                throw new Exception(err);
            }
            if (!(o instanceof ParserPool)) {
                String err = "The specified class for ParserPool (" + pp + ") does not implement " + (class$org$apache$velocity$runtime$ParserPool == null ? (class$org$apache$velocity$runtime$ParserPool = RuntimeInstance.class$("org.apache.velocity.runtime.ParserPool")) : class$org$apache$velocity$runtime$ParserPool) + " Velocity not initialized correctly.";
                this.log.error(err);
                throw new Exception(err);
            }
        } else {
            String err = "It appears that no class was specified as the ParserPool.  Please ensure that all configuration information is correct.";
            this.log.error(err);
            throw new Exception(err);
        }
        this.parserPool = (ParserPool)o;
        this.parserPool.initialize(this);
    }

    public Parser createNewParser() {
        if (!this.initialized && !this.initializing) {
            this.log.debug("Velocity was not initialized! Calling init()...");
            try {
                this.init();
            }
            catch (Exception e) {
                this.getLog().error("Could not auto-initialize Velocity", e);
                throw new IllegalStateException("Velocity could not be initialized!");
            }
        }
        Parser parser = new Parser(this);
        parser.setDirectives(this.runtimeDirectives);
        return parser;
    }

    public SimpleNode parse(Reader reader, String templateName) throws ParseException {
        return this.parse(reader, templateName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleNode parse(Reader reader, String templateName, boolean dumpNamespace) throws ParseException {
        if (!this.initialized && !this.initializing) {
            this.log.debug("Velocity was not initialized! Calling init()...");
            try {
                this.init();
            }
            catch (Exception e) {
                this.getLog().error("Could not auto-initialize Velocity", e);
                throw new IllegalStateException("Velocity could not be initialized!");
            }
        }
        SimpleNode ast = null;
        Parser parser = this.parserPool.get();
        if (parser == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Runtime : ran out of parsers. Creating a new one.  Please increment the parser.pool.size property. The current value is too small.");
            }
            parser = this.createNewParser();
        }
        if (parser != null) {
            try {
                if (dumpNamespace) {
                    this.dumpVMNamespace(templateName);
                }
                ast = parser.parse(reader, templateName);
            }
            finally {
                this.parserPool.put(parser);
            }
        } else {
            this.log.error("Runtime : ran out of parsers and unable to create more.");
        }
        return ast;
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getTemplate(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (!this.initialized && !this.initializing) {
            this.log.info("Velocity not initialized yet. Calling init()...");
            this.init();
        }
        return (Template)this.resourceManager.getResource(name, 1, encoding);
    }

    public ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getContent(name, this.getString("input.encoding", "ISO-8859-1"));
    }

    public ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (!this.initialized && !this.initializing) {
            this.log.info("Velocity not initialized yet. Calling init()...");
            this.init();
        }
        return (ContentResource)this.resourceManager.getResource(name, 2, encoding);
    }

    public String getLoaderNameForResource(String resourceName) {
        if (!this.initialized && !this.initializing) {
            this.log.debug("Velocity was not initialized! Calling init()...");
            try {
                this.init();
            }
            catch (Exception e) {
                this.getLog().error("Could not initialize Velocity", e);
                throw new IllegalStateException("Velocity could not be initialized!");
            }
        }
        return this.resourceManager.getLoaderNameForResource(resourceName);
    }

    public Log getLog() {
        return this.log;
    }

    public void warn(Object message) {
        this.getLog().warn(message);
    }

    public void info(Object message) {
        this.getLog().info(message);
    }

    public void error(Object message) {
        this.getLog().error(message);
    }

    public void debug(Object message) {
        this.getLog().debug(message);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public Directive getVelocimacro(String vmName, String templateName) {
        return this.vmFactory.getVelocimacro(vmName, templateName);
    }

    public boolean addVelocimacro(String name, String macro, String[] argArray, String sourceTemplate) {
        return this.vmFactory.addVelocimacro(name, macro, argArray, sourceTemplate);
    }

    public boolean isVelocimacro(String vmName, String templateName) {
        return this.vmFactory.isVelocimacro(vmName, templateName);
    }

    public boolean dumpVMNamespace(String namespace) {
        return this.vmFactory.dumpVMNamespace(namespace);
    }

    public String getString(String key) {
        return StringUtils.nullTrim(this.configuration.getString(key));
    }

    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.configuration.getBoolean(key, def);
    }

    public ExtendedProperties getConfiguration() {
        return this.configuration;
    }

    public Introspector getIntrospector() {
        return this.introspector;
    }

    public EventCartridge getApplicationEventCartridge() {
        return this.eventCartridge;
    }

    public Object getApplicationAttribute(Object key) {
        return this.applicationAttributes.get(key);
    }

    public Object setApplicationAttribute(Object key, Object o) {
        return this.applicationAttributes.put(key, o);
    }

    public Uberspect getUberspect() {
        return this.uberSpect;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

