/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class HiddenInputTag
extends AbstractHtmlElementTag {
    public static final String DISABLED_ATTRIBUTE = "disabled";
    private String disabled;

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    protected boolean isValidDynamicAttribute(String localName, Object value) {
        return !"type".equals(localName);
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "hidden");
        if (this.isDisabled()) {
            tagWriter.writeAttribute(DISABLED_ATTRIBUTE, DISABLED_ATTRIBUTE);
        }
        String value = this.getDisplayString(this.getBoundValue(), this.getPropertyEditor());
        tagWriter.writeAttribute("value", this.processFieldValue(this.getName(), value, "hidden"));
        tagWriter.endTag();
        return 0;
    }

    protected boolean isDisabled() throws JspException {
        return this.evaluateBoolean(DISABLED_ATTRIBUTE, this.getDisabled());
    }
}

