/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public final class MappedInterceptor {
    private final String[] pathPatterns;
    private final HandlerInterceptor interceptor;

    public MappedInterceptor(String[] pathPatterns, HandlerInterceptor interceptor) {
        this.pathPatterns = pathPatterns;
        this.interceptor = interceptor;
    }

    public MappedInterceptor(String[] pathPatterns, WebRequestInterceptor interceptor) {
        this.pathPatterns = pathPatterns;
        this.interceptor = new WebRequestHandlerInterceptorAdapter(interceptor);
    }

    public String[] getPathPatterns() {
        return this.pathPatterns;
    }

    public HandlerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean matches(String lookupPath, PathMatcher pathMatcher) {
        if (this.pathPatterns == null) {
            return true;
        }
        String[] stringArray = this.pathPatterns;
        int n = this.pathPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pathPattern = stringArray[n2];
            if (pathMatcher.match(pathPattern, lookupPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

