/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.HostnameVerifier;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.LogWrapper;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.SSLServer;
import org.apache.commons.ssl.TrustMaterial;

public class RMISocketFactoryImpl
extends RMISocketFactory {
    public static final String RMI_HOSTNAME_KEY = "java.rmi.server.hostname";
    private static final LogWrapper log = LogWrapper.getLogger(class$org$apache$commons$ssl$RMISocketFactoryImpl == null ? (class$org$apache$commons$ssl$RMISocketFactoryImpl = RMISocketFactoryImpl.class$("org.apache.commons.ssl.RMISocketFactoryImpl")) : class$org$apache$commons$ssl$RMISocketFactoryImpl);
    private volatile SocketFactory defaultClient;
    private volatile ServerSocketFactory sslServer;
    private volatile String localBindAddress = null;
    private volatile int anonymousPort = 31099;
    private Map clientMap = new TreeMap();
    private Map serverSockets = new HashMap();
    private final SocketFactory plainClient = SocketFactory.getDefault();
    static /* synthetic */ Class class$org$apache$commons$ssl$RMISocketFactoryImpl;

    public RMISocketFactoryImpl() throws GeneralSecurityException, IOException {
        this(true);
    }

    public RMISocketFactoryImpl(boolean createDefaultServer) throws GeneralSecurityException, IOException {
        SSLServer defaultServer = createDefaultServer ? new SSLServer() : null;
        SSLClient defaultClient = new SSLClient();
        HostnameVerifier verifier = HostnameVerifier.DEFAULT_AND_LOCALHOST;
        defaultClient.setHostnameVerifier(verifier);
        if (defaultServer != null) {
            defaultServer.setHostnameVerifier(verifier);
            defaultServer.useTomcatSSLMaterial();
            X509Certificate[] x509 = defaultServer.getAssociatedCertificateChain();
            if (x509 == null || x509.length < 1) {
                throw new SSLException("Cannot initialize RMI-SSL Server: no KeyMaterial!");
            }
            this.setServer(defaultServer);
        }
        this.setDefaultClient(defaultClient);
    }

    public void setServer(ServerSocketFactory f) throws GeneralSecurityException, IOException {
        this.sslServer = f;
        if (f instanceof SSLServer) {
            String rmiHostName;
            HostnameVerifier VERIFIER = HostnameVerifier.DEFAULT_AND_LOCALHOST;
            SSLServer ssl = (SSLServer)f;
            X509Certificate[] chain = ssl.getAssociatedCertificateChain();
            String[] cns = Certificates.getCNs(chain[0]);
            String[] subjectAlts = Certificates.getDNSSubjectAlts(chain[0]);
            LinkedList<String> names = new LinkedList<String>();
            if (cns != null && cns.length > 0) {
                names.add(cns[0]);
            }
            if (subjectAlts != null && subjectAlts.length > 0) {
                names.addAll(Arrays.asList(subjectAlts));
            }
            if ((rmiHostName = System.getProperty(RMI_HOSTNAME_KEY)) != null) {
                try {
                    VERIFIER.check(rmiHostName, cns, subjectAlts);
                }
                catch (SSLException ssle) {
                    String s = ssle.toString();
                    throw new SSLException("java.rmi.server.hostname of " + rmiHostName + " conflicts with SSL Server Certificate: " + s);
                }
            } else {
                String name;
                boolean hopingForBest = false;
                if (names.size() == 1 && !(name = (String)names.get(0)).startsWith("*")) {
                    System.setProperty(RMI_HOSTNAME_KEY, name);
                    log.warn("commons-ssl 'java.rmi.server.hostname' set to '" + name + "' as found in my SSL Server Certificate.");
                    hopingForBest = true;
                }
                if (!hopingForBest) {
                    SortedSet s = RMISocketFactoryImpl.getMyInternetFacingIPs();
                    Iterator it = s.iterator();
                    while (it.hasNext()) {
                        String name2 = (String)it.next();
                        try {
                            VERIFIER.check(name2, cns, subjectAlts);
                            System.setProperty(RMI_HOSTNAME_KEY, name2);
                            log.warn("commons-ssl 'java.rmi.server.hostname' set to '" + name2 + "' as found by reverse-dns against my own IP.");
                            hopingForBest = true;
                            break;
                        }
                        catch (SSLException ssle) {
                        }
                    }
                }
                if (!hopingForBest) {
                    throw new SSLException("'java.rmi.server.hostname' not present.  Must work with my SSL Server Certificate's CN field: " + names);
                }
            }
        }
        this.trustOurself();
    }

    public void setLocalBindAddress(String localBindAddress) {
        this.localBindAddress = localBindAddress;
    }

    public void setAnonymousPort(int port) {
        this.anonymousPort = port;
    }

    public void setDefaultClient(SocketFactory f) throws GeneralSecurityException, IOException {
        this.defaultClient = f;
        this.trustOurself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(String host, SocketFactory f) throws GeneralSecurityException, IOException {
        if (f != null && this.sslServer != null) {
            boolean clientIsCommonsSSL = f instanceof SSLClient;
            boolean serverIsCommonsSSL = this.sslServer instanceof SSLServer;
            if (clientIsCommonsSSL && serverIsCommonsSSL) {
                SSLClient c = (SSLClient)f;
                SSLServer s = (SSLServer)this.sslServer;
                this.trustEachOther(c, s);
            }
        }
        Set names = this.hostnamePossibilities(host);
        Iterator it = names.iterator();
        RMISocketFactoryImpl rMISocketFactoryImpl = this;
        synchronized (rMISocketFactoryImpl) {
            while (it.hasNext()) {
                this.clientMap.put(it.next(), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(String host) {
        Set names = this.hostnamePossibilities(host);
        Iterator it = names.iterator();
        RMISocketFactoryImpl rMISocketFactoryImpl = this;
        synchronized (rMISocketFactoryImpl) {
            while (it.hasNext()) {
                this.clientMap.remove(it.next());
            }
        }
    }

    public synchronized void removeClient(SocketFactory sf) {
        Iterator it = this.clientMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object o = entry.getValue();
            if (!sf.equals(o)) continue;
            it.remove();
        }
    }

    private Set hostnamePossibilities(String host) {
        String name2;
        String name1;
        int i;
        InetAddress[] addresses;
        String string = host = host != null ? host.toLowerCase().trim() : "";
        if ("".equals(host)) {
            return Collections.EMPTY_SET;
        }
        TreeSet<String> names = new TreeSet<String>();
        names.add(host);
        try {
            addresses = InetAddress.getAllByName(host);
            for (i = 0; i < addresses.length; ++i) {
                name1 = addresses[i].getHostName();
                name2 = addresses[i].getHostAddress();
                names.add(name1.trim().toLowerCase());
                names.add(name2.trim().toLowerCase());
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        try {
            host = InetAddress.getByName(host).getHostAddress();
            host = InetAddress.getByName(host).getHostName();
            names.add(host.trim().toLowerCase());
            addresses = InetAddress.getAllByName(host);
            for (i = 0; i < addresses.length; ++i) {
                name1 = addresses[i].getHostName();
                name2 = addresses[i].getHostAddress();
                names.add(name1.trim().toLowerCase());
                names.add(name2.trim().toLowerCase());
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        return names;
    }

    private void trustOurself() throws GeneralSecurityException, IOException {
        if (this.defaultClient == null || this.sslServer == null) {
            return;
        }
        boolean clientIsCommonsSSL = this.defaultClient instanceof SSLClient;
        boolean serverIsCommonsSSL = this.sslServer instanceof SSLServer;
        if (clientIsCommonsSSL && serverIsCommonsSSL) {
            SSLClient c = (SSLClient)this.defaultClient;
            SSLServer s = (SSLServer)this.sslServer;
            this.trustEachOther(c, s);
        }
    }

    private void trustEachOther(SSLClient client, SSLServer server) throws GeneralSecurityException, IOException {
        if (client != null && server != null) {
            TrustMaterial tm;
            X509Certificate[] certs = server.getAssociatedCertificateChain();
            if (certs != null && certs[0] != null) {
                tm = new TrustMaterial(certs[0]);
                client.addTrustMaterial(tm);
            }
            if ((certs = client.getAssociatedCertificateChain()) != null && certs[0] != null) {
                tm = new TrustMaterial(certs[0]);
                server.addTrustMaterial(tm);
            }
        }
    }

    public ServerSocketFactory getServer() {
        return this.sslServer;
    }

    public SocketFactory getDefaultClient() {
        return this.defaultClient;
    }

    public synchronized SocketFactory getClient(String host) {
        host = host != null ? host.trim().toLowerCase() : "";
        return (SocketFactory)this.clientMap.get(host);
    }

    public synchronized ServerSocket createServerSocket(int port) throws IOException {
        Integer key;
        ServerSocket ss;
        if (port == 0) {
            port = this.anonymousPort;
        }
        if ((ss = (ServerSocket)this.serverSockets.get(key = new Integer(port))) == null || ss.isClosed()) {
            if (ss != null && ss.isClosed()) {
                System.out.println("found closed server on port: " + port);
            }
            log.debug("commons-ssl RMI server-socket: listening on port " + port);
            ss = this.sslServer.createServerSocket(port);
            this.serverSockets.put(key, ss);
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(String host, int port) throws IOException {
        boolean isPlain22;
        SSLSocket sSLSocket;
        boolean tryPlain;
        Throwable reasonForPlainSocket;
        int soTimeout;
        SSLSocket ssl;
        Socket s;
        SocketFactory sf;
        InetAddress local;
        block22: {
            Object myInternetIps;
            host = host != null ? host.trim().toLowerCase() : "";
            local = null;
            String bindAddress = this.localBindAddress;
            if (bindAddress == null && (bindAddress = System.getProperty(RMI_HOSTNAME_KEY)) != null && !(local = InetAddress.getByName(bindAddress)).isLoopbackAddress()) {
                String ip = local.getHostAddress();
                myInternetIps = RMISocketFactoryImpl.getMyInternetFacingIPs();
                if (!myInternetIps.contains(ip)) {
                    log.warn("Cannot bind to " + ip + " since it doesn't exist on this machine.");
                    local = null;
                    bindAddress = null;
                }
            }
            if (bindAddress == null) {
                bindAddress = RMISocketFactoryImpl.getMyDefaultIP();
            }
            if (local == null && bindAddress != null) {
                local = InetAddress.getByName(bindAddress);
                this.localBindAddress = local.getHostName();
            }
            myInternetIps = this;
            synchronized (myInternetIps) {
                sf = (SocketFactory)this.clientMap.get(host);
            }
            if (sf == null) {
                sf = this.defaultClient;
            }
            s = null;
            ssl = null;
            soTimeout = Integer.MIN_VALUE;
            reasonForPlainSocket = null;
            tryPlain = false;
            s = sf.createSocket(host, port, local, 0);
            soTimeout = s.getSoTimeout();
            if (s instanceof SSLSocket) break block22;
            Socket socket = s;
            Object var15_17 = null;
            boolean isPlain22 = tryPlain || s != null && ssl == null;
            String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
            String localIP = local != null ? local.getHostAddress() : "ANY";
            StringBuffer buf = new StringBuffer(64);
            buf.append(socket2);
            buf.append(localIP);
            buf.append(" --> ");
            buf.append(host);
            buf.append(":");
            buf.append(port);
            log.debug(buf.toString());
            return socket;
        }
        try {
            ssl = (SSLSocket)s;
            ssl.setSoTimeout(15000);
            ssl.getSession().getPeerCertificates();
            ssl.setSoTimeout(soTimeout);
            sSLSocket = ssl;
            Object var15_18 = null;
            isPlain22 = tryPlain || s != null && ssl == null;
        }
        catch (IOException ioe) {
            boolean isPlain22;
            try {
                block23: {
                    Throwable t;
                    for (t = ioe; !tryPlain && t != null; t = t.getCause()) {
                        tryPlain = tryPlain || t instanceof EOFException;
                        tryPlain = tryPlain || t instanceof InterruptedIOException;
                        tryPlain = tryPlain || t instanceof SSLProtocolException;
                    }
                    if (!tryPlain && ioe instanceof SSLPeerUnverifiedException) {
                        try {
                            if (ssl == null) break block23;
                            ssl.startHandshake();
                        }
                        catch (IOException ioe2) {
                            ioe = ioe2;
                            for (t = ioe2; !tryPlain && t != null; t = t.getCause()) {
                                tryPlain = tryPlain || t instanceof EOFException;
                                tryPlain = tryPlain || t instanceof InterruptedIOException;
                                tryPlain = tryPlain || t instanceof SSLProtocolException;
                            }
                        }
                    }
                }
                if (!tryPlain) {
                    log.debug("commons-ssl RMI-SSL failed: " + ioe);
                    throw ioe;
                }
                reasonForPlainSocket = ioe;
                Object var15_19 = null;
                isPlain22 = tryPlain || s != null && ssl == null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                boolean isPlain22 = tryPlain || s != null && ssl == null;
                String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
                String localIP = local != null ? local.getHostAddress() : "ANY";
                StringBuffer buf = new StringBuffer(64);
                buf.append(socket2);
                buf.append(localIP);
                buf.append(" --> ");
                buf.append(host);
                buf.append(":");
                buf.append(port);
                log.debug(buf.toString());
                throw throwable;
            }
            String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
            String localIP = local != null ? local.getHostAddress() : "ANY";
            StringBuffer buf = new StringBuffer(64);
            buf.append(socket2);
            buf.append(localIP);
            buf.append(" --> ");
            buf.append(host);
            buf.append(":");
            buf.append(port);
            log.debug(buf.toString());
            {
            }
        }
        String socket2 = isPlain22 ? "RMI plain-socket " : "RMI ssl-socket ";
        String localIP = local != null ? local.getHostAddress() : "ANY";
        StringBuffer buf = new StringBuffer(64);
        buf.append(socket2);
        buf.append(localIP);
        buf.append(" --> ");
        buf.append(host);
        buf.append(":");
        buf.append(port);
        log.debug(buf.toString());
        return sSLSocket;
        sf = this.plainClient;
        s = JavaImpl.connect(null, sf, host, port, local, 0, 15000);
        if (soTimeout != Integer.MIN_VALUE) {
            s.setSoTimeout(soTimeout);
        }
        try {
            this.setClient(host, this.plainClient);
            String msg = "RMI downgrading from SSL to plain-socket for " + host + " because of " + reasonForPlainSocket;
            log.warn(msg, reasonForPlainSocket);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("can't happen because we're using plain socket", gse);
        }
        return s;
    }

    public static String getMyDefaultIP() {
        String anInternetIP = "64.111.122.211";
        String ip = null;
        try {
            DatagramSocket dg = new DatagramSocket();
            dg.setSoTimeout(250);
            InetAddress addr = InetAddress.getByName(anInternetIP);
            dg.connect(addr, 12345);
            InetAddress localAddr = dg.getLocalAddress();
            ip = localAddr.getHostAddress();
            dg.close();
            if (localAddr.isLoopbackAddress() || "0.0.0.0".equals(ip)) {
                ip = null;
            }
        }
        catch (IOException ioe) {
            log.debug("Bogus UDP didn't work: " + ioe);
        }
        return ip;
    }

    public static SortedSet getMyInternetFacingIPs() throws SocketException {
        TreeSet<String> set = new TreeSet<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> en2 = ni.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                String ip = addr.getHostAddress();
                String reverse = addr.getHostName();
                set.add(ip);
                set.add(reverse);
            }
        }
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

