/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolType;
import com.supermap.ui.InternalSymbolLine;
import com.supermap.ui.InternalToolkitControl;
import com.supermap.ui.LabelInfo;
import com.supermap.ui.SymbolPanel;
import com.supermap.ui.UIEnvironment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SymbolSearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField _$14;
    private SymbolPanel _$13;
    private static final String _$12 = "System";
    private static final String[] _$11 = new String[]{"System 0", "System 1", "System 2", "System 3", "System 4", "System 5", "System 6"};
    private static final int _$10 = 510;
    private static final int _$9 = 420;
    private static final int _$8 = 88;
    private static final int _$7 = 87;
    private static final int _$6 = 108;
    private SymbolType _$5;
    private LinkedList<String> _$4;
    private JPopupMenu _$3;
    private static final int _$2 = 80;
    private static final int _$1 = 100;

    public SymbolSearchPanel(SymbolPanel symbolPanel) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        this._$13 = symbolPanel;
        this._$5 = symbolPanel.getType();
        this._$4 = new LinkedList();
        JLabel jLabel = new JLabel();
        jLabel.setText(" \u641c\u7d22\uff1a");
        Box box = Box.createHorizontalBox();
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.getTextFieldSymbolSearch());
        this.add(box);
    }

    protected JTextField getTextFieldSymbolSearch() {
        if (this._$14 == null) {
            this._$14 = new JTextField();
            this._$14.setPreferredSize(new Dimension(140, 25));
            this._$14.setMinimumSize(new Dimension(140, 25));
            this._$14.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    SymbolSearchPanel.this.search();
                    String string = SymbolSearchPanel.this._$14.getText();
                    SymbolSearchPanel.this.refreshPrevSearches(string);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SymbolSearchPanel.this.search();
                    String string = SymbolSearchPanel.this._$14.getText();
                    SymbolSearchPanel.this.refreshPrevSearches(string);
                }
            });
        }
        return this._$14;
    }

    public void popMenu(int n, int n2) {
        this._$3 = new JPopupMenu();
        Iterator iterator = this._$4.iterator();
        while (iterator.hasNext()) {
            this._$3.add(new PrevSearchAction((String)iterator.next()));
        }
    }

    protected void search() {
        if (this._$5.equals((Object)SymbolType.MARKER)) {
            this.searchMarker(this._$14.getText());
        } else if (this._$5.equals((Object)SymbolType.LINE)) {
            this.searchLine(this._$14.getText());
        } else if (this._$5.equals((Object)SymbolType.FILL)) {
            this.searchFill(this._$14.getText());
        }
    }

    protected void searchMarker(String string) {
        if (string.trim().length() == 0) {
            this._$13.paintMarkerSymbols();
            return;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this._$1(string, "0", arrayList, arrayList2, SymbolType.MARKER);
        Symbol[] symbolArray = new Symbol[arrayList.size()];
        Integer[] integerArray = new Integer[arrayList2.size()];
        this.paintSymbolsForMarkerSearch(48, 48, this._$13.getPaintPoint(), this._$13.getPanelSymbolsView(), arrayList.toArray(symbolArray), arrayList2.toArray(integerArray));
    }

    protected void searchLine(String string) {
        if (string.trim().length() == 0) {
            this._$13.paintLineSymbols();
            return;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this._$1(string, "012345", arrayList, arrayList2, SymbolType.LINE);
        Symbol[] symbolArray = new Symbol[arrayList.size()];
        Integer[] integerArray = new Integer[arrayList2.size()];
        this.paintSymbolsForLineSearch(64, 64, this._$13.getPaintLine(), this._$13.getPanelSymbolsView(), arrayList.toArray(symbolArray), arrayList2.toArray(integerArray));
    }

    protected void searchFill(String string) {
        if (string.trim().length() == 0) {
            this._$13.paintFillSymbols();
            return;
        }
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this._$1(string, "0123456", arrayList, arrayList2, SymbolType.FILL);
        Symbol[] symbolArray = new Symbol[arrayList.size()];
        Integer[] integerArray = new Integer[arrayList2.size()];
        this.paintSymbolsForFillSearch(80, 80, this._$13.getPaintRegion(), this._$13.getPanelSymbolsView(), arrayList.toArray(symbolArray), arrayList2.toArray(integerArray));
    }

    private void _$1(String string, String string2, ArrayList<Symbol> arrayList, ArrayList<Integer> arrayList2, SymbolType symbolType) {
        block10: {
            int n;
            CharSequence charSequence;
            Object object;
            String string3;
            block11: {
                int n2;
                block9: {
                    string3 = string.trim().toLowerCase();
                    if (_$12.toLowerCase().indexOf(string3) != -1 && this._$13.getSymbolGroup((Object[])(object = this._$13.getSymbolsTree().getSelectionPath().getPath())).equals(this._$13.getRootGroup())) {
                        for (int i = 0; i < string2.length(); ++i) {
                            arrayList2.add(i);
                        }
                    }
                    if (string2.indexOf(string3) != -1 && arrayList2.indexOf(object = Integer.valueOf(string3)) == -1) {
                        arrayList2.add((Integer)object);
                    }
                    object = this._$13.getAllLabelInfo();
                    charSequence = string3.subSequence(0, string3.length());
                    if (!symbolType.equals((Object)SymbolType.MARKER)) break block9;
                    if (_$11[0].toLowerCase().equals(string3) && arrayList2.indexOf(0) == -1) {
                        arrayList2.add(0);
                    }
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        LabelInfo labelInfo = (LabelInfo)((ArrayList)object).get(i);
                        String string4 = labelInfo.getSymbolName();
                        if (!string4.toLowerCase().contains(charSequence)) continue;
                        int n3 = labelInfo.getSymbolID();
                        Symbol symbol = this._$13.getResources().getMarkerLibrary().findSymbol(n3);
                        if (symbol == null) continue;
                        arrayList.add(symbol);
                    }
                    break block10;
                }
                if (!symbolType.equals((Object)SymbolType.LINE)) break block11;
                for (n2 = 0; n2 < 6; ++n2) {
                    if (!_$11[n2].toLowerCase().equals(string3) || arrayList2.indexOf(n2) != -1) continue;
                    arrayList2.add(n2);
                    break;
                }
                for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                    LabelInfo labelInfo = (LabelInfo)((ArrayList)object).get(n2);
                    String string5 = labelInfo.getSymbolName();
                    if (!string5.toLowerCase().contains(charSequence)) continue;
                    int n4 = labelInfo.getSymbolID();
                    Symbol symbol = this._$13.getResources().getLineLibrary().findSymbol(n4);
                    if (symbol == null) continue;
                    arrayList.add(symbol);
                }
                break block10;
            }
            if (!symbolType.equals((Object)SymbolType.FILL)) break block10;
            for (n = 0; n < 7; ++n) {
                if (!_$11[n].toLowerCase().equals(string3) || arrayList2.indexOf(n) != -1) continue;
                arrayList2.add(n);
                break;
            }
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                LabelInfo labelInfo = (LabelInfo)((ArrayList)object).get(n);
                String string6 = labelInfo.getSymbolName();
                if (!string6.toLowerCase().contains(charSequence)) continue;
                int n5 = labelInfo.getSymbolID();
                Symbol symbol = this._$13.getResources().getFillLibrary().findSymbol(n5);
                if (symbol == null) continue;
                arrayList.add(symbol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSymbolsForMarkerSearch(int n, int n2, GeoPoint geoPoint, JPanel jPanel, Symbol[] symbolArray, Integer[] integerArray) {
        try {
            Serializable serializable;
            Object object;
            Object object2;
            BufferedImage bufferedImage;
            int n3;
            jPanel.removeAll();
            int n4 = symbolArray.length;
            int n5 = 0;
            int n6 = 6;
            ArrayList<LabelInfo> arrayList = this._$13.getLabelInfoArray();
            arrayList.clear();
            for (n3 = 0; n3 < integerArray.length; ++n3) {
                bufferedImage = new BufferedImage(n, n2 - 4, 2);
                object2 = geoPoint;
                object2.getStyle().setMarkerSymbolID(integerArray[n3].intValue());
                InternalToolkitControl.internalDraw((Geometry)object2, this._$13.getResources(), bufferedImage.getGraphics());
                object = "System " + integerArray[n3];
                serializable = this._$13.getSymbolLabel((String)object, bufferedImage);
                ((Component)serializable).setName(String.valueOf(integerArray[n3]));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(510, (n5 + 1) * 88));
                jPanel.add((Component)serializable);
                LabelInfo labelInfo = new LabelInfo((JLabel)serializable, n5, n3 % n6, integerArray[n3], (String)object);
                arrayList.add(labelInfo);
            }
            for (n3 = integerArray.length; n3 < n4 + integerArray.length; ++n3) {
                bufferedImage = symbolArray[n3 - integerArray.length];
                object2 = new BufferedImage(n, n2 - 4, 2);
                object = (SymbolMarker)bufferedImage;
                serializable = object.getOrigin();
                int n7 = ((Point)serializable).x * n / UIEnvironment.g_symbolPointMax;
                int n8 = ((Point)serializable).y * n2 / UIEnvironment.g_symbolPointMax;
                GeoPoint geoPoint2 = geoPoint;
                geoPoint2.setX((double)n7);
                geoPoint2.setY((double)n8);
                geoPoint2.getStyle().setMarkerSymbolID(bufferedImage.getID());
                InternalToolkitControl.internalDraw((Geometry)geoPoint2, this._$13.getResources(), ((BufferedImage)object2).getGraphics());
                JLabel jLabel = this._$13.getSymbolLabel(bufferedImage.getName(), (BufferedImage)object2);
                jLabel.setName(String.valueOf(bufferedImage.getID()));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(510, (n5 + 1) * 88));
                jPanel.add(jLabel);
                LabelInfo labelInfo = new LabelInfo(jLabel, n5, n3 % n6, bufferedImage.getID(), bufferedImage.getName());
                arrayList.add(labelInfo);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$13.getSymbolBasicInfoPanel().refreshComboBox(this._$13.getLabelInfoArray());
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSymbolsForLineSearch(int n, int n2, GeoLine geoLine, JPanel jPanel, Symbol[] symbolArray, Integer[] integerArray) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            BufferedImage bufferedImage;
            int n3;
            jPanel.removeAll();
            int n4 = symbolArray.length;
            int n5 = 0;
            int n6 = 6;
            ArrayList<LabelInfo> arrayList = this._$13.getLabelInfoArray();
            arrayList.clear();
            for (n3 = 0; n3 < integerArray.length; ++n3) {
                bufferedImage = new BufferedImage(n, n2 - 8, 2);
                object4 = geoLine;
                object4.getStyle().setLineSymbolID(integerArray[n3].intValue());
                InternalToolkitControl.internalDraw((Geometry)object4, this._$13.getResources(), bufferedImage.getGraphics());
                object3 = "System " + integerArray[n3];
                if (integerArray[n3] == 5) {
                    object2 = bufferedImage.getGraphics();
                    object = new Font("Dialog", 0, 14);
                    ((Graphics)object2).setFont((Font)object);
                    ((Graphics)object2).setColor(Color.blue);
                    ((Graphics)object2).drawString("NULL", 16, 38);
                }
                object2 = this._$13.getSymbolLabel((String)object3, bufferedImage);
                ((Component)object2).setName(String.valueOf(integerArray[n3]));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(510, (n5 + 1) * 87));
                jPanel.add((Component)object2);
                object = new LabelInfo((JLabel)object2, n5, n3 % n6, integerArray[n3], (String)object3);
                arrayList.add((LabelInfo)object);
            }
            for (n3 = integerArray.length; n3 < n4 + integerArray.length; ++n3) {
                bufferedImage = symbolArray[n3 - integerArray.length];
                object4 = new BufferedImage(n, n2 - 8, 2);
                object3 = (SymbolLine)bufferedImage;
                object2 = geoLine;
                object2.getStyle().setLineSymbolID(object3.getID());
                InternalSymbolLine.internalDraw((SymbolLine)bufferedImage, ((BufferedImage)object4).getGraphics(), (Geometry)object2);
                object = this._$13.getSymbolLabel(bufferedImage.getName(), (BufferedImage)object4);
                ((Component)object).setName(String.valueOf(bufferedImage.getID()));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(510, (n5 + 1) * 87));
                jPanel.add((Component)object);
                LabelInfo labelInfo = new LabelInfo((JLabel)object, n5, n3 % n6, bufferedImage.getID(), bufferedImage.getName());
                arrayList.add(labelInfo);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$13.getSymbolBasicInfoPanel().refreshComboBox(this._$13.getLabelInfoArray());
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSymbolsForFillSearch(int n, int n2, GeoRegion geoRegion, JPanel jPanel, Symbol[] symbolArray, Integer[] integerArray) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            BufferedImage bufferedImage;
            int n3;
            jPanel.removeAll();
            int n4 = symbolArray.length;
            int n5 = 0;
            int n6 = 4;
            ArrayList<LabelInfo> arrayList = this._$13.getLabelInfoArray();
            arrayList.clear();
            for (n3 = 0; n3 < integerArray.length; ++n3) {
                bufferedImage = new BufferedImage(n, n2 - 2, 2);
                object4 = geoRegion;
                object4.getStyle().setFillSymbolID(integerArray[n3].intValue());
                InternalToolkitControl.internalDraw((Geometry)object4, this._$13.getResources(), bufferedImage.getGraphics());
                object3 = "System " + integerArray[n3];
                if (integerArray[n3] == 1) {
                    object2 = bufferedImage.getGraphics();
                    object = new Font("Dialog", 0, 14);
                    ((Graphics)object2).setFont((Font)object);
                    ((Graphics)object2).setColor(Color.blue);
                    ((Graphics)object2).drawString("NULL", 25, 45);
                }
                object2 = this._$13.getSymbolLabelForRegion((String)object3, bufferedImage);
                ((Component)object2).setName(String.valueOf(integerArray[n3]));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(420, (n5 + 1) * 108));
                jPanel.add((Component)object2);
                object = new LabelInfo((JLabel)object2, n5, n3 % n6, integerArray[n3], (String)object3);
                arrayList.add((LabelInfo)object);
            }
            for (n3 = integerArray.length; n3 < n4 + integerArray.length; ++n3) {
                bufferedImage = symbolArray[n3 - integerArray.length];
                object4 = new BufferedImage(n, n2 - 2, 2);
                object3 = (SymbolFill)bufferedImage;
                object2 = geoRegion;
                object2.getStyle().setFillSymbolID(object3.getID());
                InternalToolkitControl.internalDraw((Geometry)object2, this._$13.getResources(), ((BufferedImage)object4).getGraphics());
                object = this._$13.getSymbolLabelForRegion(bufferedImage.getName(), (BufferedImage)object4);
                ((Component)object).setName(String.valueOf(bufferedImage.getID()));
                if (n3 != 0 && n3 % n6 == 0) {
                    ++n5;
                }
                jPanel.setPreferredSize(new Dimension(420, (n5 + 1) * 108));
                jPanel.add((Component)object);
                LabelInfo labelInfo = new LabelInfo((JLabel)object, n5, n3 % n6, bufferedImage.getID(), bufferedImage.getName());
                arrayList.add(labelInfo);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            this._$13.getSymbolBasicInfoPanel().refreshComboBox(this._$13.getLabelInfoArray());
            jPanel.getParent().validate();
            jPanel.getParent().repaint();
            jPanel.validate();
            jPanel.repaint();
        }
    }

    protected void refreshPrevSearches(String string) {
        if (!string.equals("") && !this._$4.contains(string)) {
            this._$4.addFirst(string);
        }
        if (this._$4.size() > 10) {
            this._$4.removeLast();
        }
    }

    class PrevSearchAction
    extends AbstractAction {
        private String _$1;

        public PrevSearchAction(String string) {
            this._$1 = string;
            this.putValue("Name", this._$1);
        }

        public String toString() {
            return this._$1;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SymbolSearchPanel.this.getTextFieldSymbolSearch().setText(this._$1);
        }
    }
}

