/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.RouteNative;
import com.supermap.realspace.RouteStop;
import com.supermap.realspace.RouteStops;
import com.supermap.realspace.Scene;

public class Route
extends InternalHandleDisposable {
    FlyManager m_flyManager;
    RouteStops m_routeStops;
    GeoStyle3D m_geoStyle3D;

    public Route() {
        long l = RouteNative.jni_New();
        this.setHandle(l, true);
    }

    public Route(Route route) {
        if (route.getHandle() == 0L) {
            String string = InternalResource.loadString("route", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = RouteNative.jni_Clone(route.getHandle());
        this.setHandle(l, true);
    }

    protected Route(long l) {
        this.setHandle(l, false);
        this.getStops();
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_ToXML(this.getHandle());
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromXML", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = RouteNative.jni_FromXML(this.getHandle(), string);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        return bl;
    }

    public GeoLine3D toGeoLine3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toGeoLine3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteStops routeStops = this.getStops();
        int n = routeStops.getCount();
        Point3Ds point3Ds = new Point3Ds();
        for (int i = 0; i < n; ++i) {
            RouteStop routeStop = routeStops.get(i);
            Camera camera = routeStop.getCamera();
            Point3D point3D = new Point3D(camera.getLongitude(), camera.getLatitude(), camera.getAltitude());
            point3Ds.add(point3D);
        }
        GeoLine3D geoLine3D = new GeoLine3D(point3Ds);
        geoLine3D.setStyle3D(this.getDefaultStyle());
        return geoLine3D;
    }

    public boolean fromGeoLine3D(GeoLine3D geoLine3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromGeoLine3D", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoLine3D == null) {
            String string = InternalResource.loadString("fromGeoLine3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine3D geoLine3D2 = new GeoLine3D(geoLine3D);
        boolean bl = RouteNative.jni_FromGeoLine3D(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine3D2));
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.STOP_COUNT_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine3D);
        return bl;
    }

    public RouteStops getStops() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRouteStops", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_routeStops == null && (l = RouteNative.jni_GetRouteStops(this.getHandle())) != 0L) {
            this.m_routeStops = new RouteStops(l);
        }
        this.m_routeStops.m_flyManager = this.m_flyManager;
        return this.m_routeStops;
    }

    public void setStops(RouteStops routeStops) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRouteStops", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (routeStops == null) {
            String string = InternalResource.loadString("setRouteStops", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(routeStops);
        if (l == 0L) {
            String string = InternalResource.loadString("setRouteStops", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        RouteNative.jni_SetRouteStops(this.getHandle(), l);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public GeoStyle3D getDefaultStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoStyle3D == null && (l = RouteNative.jni_GetDefaultStyle(this.getHandle())) != 0L) {
            this.m_geoStyle3D = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_geoStyle3D;
    }

    public void setDefaultStyle(GeoStyle3D geoStyle3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle3D == null) {
            String string = InternalResource.loadString("setDefaultStyle", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D2 = geoStyle3D.clone();
        RouteNative.jni_SetDefaultStyle(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D2));
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
    }

    public boolean isAltitudeFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAltitudeFixed", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsAltitudeFixed(this.getHandle());
    }

    public void setAltitudeFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAltitudeFixed", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsAltitudeFixed(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isHeadingFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isHeadingFixed", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsHeadingFixed(this.getHandle());
    }

    public void setHeadingFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeadingFixed", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsHeadingFixed(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isLinesVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLinesVisible", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsLinesVisible(this.getHandle());
    }

    public void setLinesVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLinesVisible", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsLinesVisible(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isStopsVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isStopsVisible", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsStopsVisible(this.getHandle());
    }

    public void setStopsVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStopsVisible", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsStopsVisible(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isTiltFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTiltFixed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsTiltFixed(this.getHandle());
    }

    public void setTiltFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTiltFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsTiltFixed(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isFlyingLoop() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFlyCircle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsFlyingLoop(this.getHandle());
    }

    public void setFlyingLoop(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFlyCircle(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsFlyingLoop(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public boolean isFlyAlongTheRoute() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFlyCircle(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetIsFlyAlongTheRoute(this.getHandle());
    }

    public void setFlyAlongTheRoute(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFlyAlongLine(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetIsFlyAlongTheRoute(this.getHandle(), bl);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public double getSpeed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGlobalSpeed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetSpeed(this.getHandle());
    }

    public void setSpeed(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGlobalSpeed(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        RouteNative.jni_SetSpeed(this.getHandle(), d);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return RouteNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setName", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        RouteNative.jni_SetName(this.getHandle(), string);
        if (this.m_flyManager != null) {
            PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.ROUTE_PROPERTIES_CHANGED);
            this.m_flyManager.firePropertiesChanged(propertiesChangedEvent);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            RouteNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        if (this.m_routeStops != null) {
            this.m_routeStops.clearHandle();
            this.m_routeStops = null;
        }
        if (this.m_geoStyle3D != null) {
            this.m_geoStyle3D.dispose();
        }
    }

    protected void setScene(Scene scene) {
        if (scene != null) {
            RouteNative.jni_SetScene(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)scene));
        }
    }
}

