/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.core;

import com.supermap.geoprocessor.base.ClearEnvironment;
import com.supermap.geoprocessor.common.LogProvider;
import com.supermap.geoprocessor.common.ProcessStatus;
import com.supermap.geoprocessor.core.RunningContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;

public class MethodRunner {
    private String className;
    private String method;
    private Object[] args = null;
    private RunningContext runningContext = null;
    private String caption = "";
    private static Log LOG = LogProvider.getLog(MethodRunner.class);

    public MethodRunner(String string, String string2, Object[] objectArray, RunningContext runningContext, String string3) {
        this.className = string;
        this.method = string2;
        this.args = objectArray;
        this.runningContext = runningContext;
        this.caption = string3;
    }

    public boolean exectue() throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        if (this.runningContext == null) {
            LOG.error((Object)"RunningContext is null");
            return false;
        }
        if (this.runningContext != null && !this.runningContext.isContinue() && !this.className.equalsIgnoreCase(ClearEnvironment.class.getName())) {
            LOG.debug((Object)("isContinue=false,Class:" + this.className + " return false"));
            return false;
        }
        Class<?> clazz = Class.forName(this.className);
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        Object[] objectArray = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getName() != this.method) continue;
            method = methodArray[i];
            break;
        }
        if (method != null) {
            List<Object> list;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length > 0) {
                if (classArray[classArray.length - 1].getName().equalsIgnoreCase(RunningContext.class.getName())) {
                    list = Arrays.asList(this.args);
                    ArrayList<Object> arrayList = new ArrayList<Object>(list);
                    arrayList.add(this.runningContext);
                    objectArray = arrayList.toArray();
                } else {
                    objectArray = this.args;
                }
            }
            if (this.runningContext != null) {
                this.runningContext.updateProcessStatus(ProcessStatus.RUNNING);
                this.runningContext.writeInfo("\u5f00\u59cb->" + this.caption);
            }
            list = null;
            try {
                LOG.debug((Object)"MehtodRunner.invoke begin");
                list = method.invoke(null, objectArray);
                LOG.debug((Object)"MehtodRunner.invoke end");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.runningContext.updateProcessStatus(ProcessStatus.FAILED);
                this.runningContext.writeInfo("\u5931\u8d25->" + this.caption + " throw InvocationTargetException");
                this.runningContext.writeInfo(invocationTargetException.getMessage());
                LOG.debug((Object)invocationTargetException);
                LOG.debug((Object)"RunningCOntext.stop()");
                this.runningContext.getRootContext().stop();
                return false;
            }
            LOG.debug((Object)("Invoke " + this.className + "." + this.method + ", result=" + list));
            if (list != null && list instanceof Boolean && !((Boolean)((Object)list)).booleanValue()) {
                this.runningContext.updateProcessStatus(ProcessStatus.FAILED);
                this.runningContext.writeInfo("\u5931\u8d25->" + this.caption);
                this.runningContext.getRootContext().stop();
                return false;
            }
            this.runningContext.updateProgress(100.0);
            this.runningContext.updateProcessStatus(ProcessStatus.SUCCEED);
            this.runningContext.writeInfo("\u6210\u529f->" + this.caption);
            return true;
        }
        LOG.error((Object)("not find the method  named" + this.method));
        return false;
    }
}

