/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.common;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.supermap.geoprocessor.common.ConnectionProvider;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;

public class PoolingConnectionProvider
implements ConnectionProvider {
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "URL";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_MAX_CONNECTIONS = "maxConnections";
    public static final String DB_VALIDATION_QUERY = "validationQuery";
    public static final String DB_IDLE_VALIDATION_SECONDS = "idleConnectionValidationSeconds";
    public static final String DB_VALIDATE_ON_CHECKOUT = "validateOnCheckout";
    public static final int DEFAULT_DB_MAX_CONNECTIONS = 10;
    private static final String DB_DISCARD_IDLE_CONNECTIONS_SECONDS = "discardIdleConnectionsSeconds";
    private ComboPooledDataSource datasource;

    public PoolingConnectionProvider(String string, String string2, String string3, String string4, int n, String string5) throws SQLException {
        this.initialize(string, string2, string3, string4, n, string5, false, 18000, 25000);
    }

    private void initialize(String string, String string2, String string3, String string4, int n, String string5, boolean bl, int n2, int n3) throws SQLException {
        if (string2 == null) {
            throw new SQLException("DBPool could not be created: DB URL cannot be null");
        }
        if (string == null) {
            throw new SQLException("DBPool '" + string2 + "' could not be created: " + "DB driver class name cannot be null!");
        }
        if (n < 0) {
            throw new SQLException("DBPool '" + string2 + "' could not be created: " + "Max connections must be greater than zero!");
        }
        this.datasource = new ComboPooledDataSource();
        try {
            this.datasource.setDriverClass(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.datasource.setJdbcUrl(string2);
        this.datasource.setUser(string3);
        this.datasource.setPassword(string4);
        this.datasource.setMaxPoolSize(n);
        this.datasource.setMinPoolSize(1);
        this.datasource.setMaxIdleTime(n3);
        if (string5 != null) {
            this.datasource.setPreferredTestQuery(string5);
            if (!bl) {
                this.datasource.setTestConnectionOnCheckin(true);
            } else {
                this.datasource.setTestConnectionOnCheckout(true);
            }
            this.datasource.setIdleConnectionTestPeriod(n2);
        }
    }

    protected ComboPooledDataSource getDataSource() {
        return this.datasource;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }
}

