/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import com.supermap.data.TransformationError;
import com.supermap.data.TransformationMode;
import com.supermap.data.TransformationNative;
import com.supermap.data.TransformationResampleMode;
import java.util.concurrent.CopyOnWriteArrayList;

public class Transformation
extends InternalHandleDisposable {
    private Point2Ds _$5 = null;
    private Point2Ds _$4 = null;
    private TransformationMode _$3 = TransformationMode.RECT;
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected long m_selfEventHandle;

    public Transformation() {
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new Point2Ds();
        this._$4 = new Point2Ds();
    }

    public Transformation(Transformation transformation) {
        if (transformation == null) {
            String string = InternalResource.loadString("transformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformation.getHandle() == 0L) {
            String string = InternalResource.loadString("transformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new Point2Ds();
        this._$4 = new Point2Ds();
        InternalHandleDisposable.makeSureNativeObjectLive(transformation);
    }

    public Transformation(Point2Ds point2Ds, Point2Ds point2Ds2, TransformationMode transformationMode) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("originalControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds2 == null) {
            String string = InternalResource.loadString("targetControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformationMode == null) {
            String string = InternalResource.loadString("transformationMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = TransformationNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new Point2Ds();
        this._$4 = new Point2Ds();
        this.setOriginalControlPoints(point2Ds);
        this.setTargetControlPoints(point2Ds2);
        this._$3 = transformationMode;
    }

    public Point2Ds getOriginalControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOriginalControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public boolean rectify(Dataset dataset) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE) {
            String string = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1();
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        boolean bl = TransformationNative.jni_RectifyDirect(this.getHandle(), dataset.getHandle(), this._$3.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl;
    }

    public Dataset rectify(Dataset dataset, Datasource datasource, String string, TransformationResampleMode transformationResampleMode, double d) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string2 = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE) {
            String string3 = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this._$1();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_RectifyResample(this.getHandle(), dataset.getHandle(), transformationResampleMode.value(), d, datasource.getHandle(), string, this._$3.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        Dataset dataset2 = null;
        if (l != 0L) {
            dataset2 = Dataset.createInstance(l, dataset.getType(), datasource);
            Datasets.add(datasource.getDatasets(), dataset2);
        }
        return dataset2;
    }

    public Dataset rectify(Dataset dataset, Datasource datasource, String string) {
        if (dataset == null || InternalHandle.getHandle(dataset) == 0L) {
            String string2 = InternalResource.loadString("rectifyDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (dataset.getType() != DatasetType.GRID && dataset.getType() != DatasetType.IMAGE) {
            String string3 = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this._$1();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_Rectify(this.getHandle(), dataset.getHandle(), datasource.getHandle(), string, this._$3.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        Dataset dataset2 = null;
        if (l != 0L) {
            dataset2 = Dataset.createInstance(l, dataset.getType(), datasource);
            Datasets.add(datasource.getDatasets(), dataset2);
        }
        return dataset2;
    }

    public boolean rectify(Dataset[] datasetArray) {
        if (datasetArray == null) {
            String string = InternalResource.loadString("rectifyDatasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1();
        boolean bl = true;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        for (int i = 0; i < datasetArray.length; ++i) {
            if (datasetArray[i] == null || InternalHandle.getHandle(datasetArray[i]) == 0L) {
                String string = InternalResource.loadString("rectifyDatasets", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetArray[i].getType() != DatasetType.GRID && datasetArray[i].getType() != DatasetType.IMAGE) {
                String string = InternalResource.loadString("rectifyDatasets", "RecordsetDatasetTypeIsNotSupported", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (TransformationNative.jni_RectifyDirect(this.getHandle(), datasetArray[i].getHandle(), this._$3.value(), this.m_selfEventHandle)) continue;
            bl = false;
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean transform(DatasetVector datasetVector) {
        if (datasetVector == null || InternalHandle.getHandle(datasetVector) == 0L) {
            String string = InternalResource.loadString("transformDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.CAD && datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION && datasetVector.getType() != DatasetType.NETWORK && datasetVector.getType() != DatasetType.TEXT && datasetVector.getType() != DatasetType.POINT3D && datasetVector.getType() != DatasetType.LINE3D && datasetVector.getType() != DatasetType.REGION3D && datasetVector.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("transformDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1();
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        boolean bl = TransformationNative.jni_TransformDirect(this.getHandle(), datasetVector.getHandle(), this._$3.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return bl;
    }

    public DatasetVector transform(DatasetVector datasetVector, Datasource datasource, String string) {
        if (datasetVector == null || InternalHandle.getHandle(datasetVector) == 0L) {
            String string2 = InternalResource.loadString("transformDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (datasetVector.getType() != DatasetType.CAD && datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION && datasetVector.getType() != DatasetType.NETWORK && datasetVector.getType() != DatasetType.TEXT && datasetVector.getType() != DatasetType.POINT3D && datasetVector.getType() != DatasetType.LINE3D && datasetVector.getType() != DatasetType.REGION3D && datasetVector.getType() != DatasetType.NETWORK3D) {
            String string3 = InternalResource.loadString("rectifyDataset", "RecordsetDatasetTypeIsNotSupported", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null || InternalHandle.getHandle(datasource) == 0L) {
            String string4 = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("outputDatasetName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this._$1();
        long l = 0L;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        l = TransformationNative.jni_Transform(this.getHandle(), datasetVector.getHandle(), datasource.getHandle(), string, this._$3.value(), this.m_selfEventHandle);
        this.clearSelfEventHandle();
        DatasetVector datasetVector2 = null;
        if (l != 0L) {
            datasetVector2 = DatasetVector.createInstance(l, datasource);
            Datasets.add(datasource.getDatasets(), datasetVector2);
        }
        return datasetVector2;
    }

    public boolean transform(DatasetVector[] datasetVectorArray) {
        if (datasetVectorArray == null) {
            String string = InternalResource.loadString("transformDatasets", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        this.m_selfEventHandle = TransformationNative.jni_NewSelfEventHandle(this);
        for (int i = 0; i < datasetVectorArray.length; ++i) {
            if (datasetVectorArray[i] == null || InternalHandle.getHandle(datasetVectorArray[i]) == 0L) {
                String string = InternalResource.loadString("transformDatasets", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetVectorArray[i].getType() != DatasetType.CAD && datasetVectorArray[i].getType() != DatasetType.POINT && datasetVectorArray[i].getType() != DatasetType.LINE && datasetVectorArray[i].getType() != DatasetType.REGION && datasetVectorArray[i].getType() != DatasetType.NETWORK && datasetVectorArray[i].getType() != DatasetType.TEXT && datasetVectorArray[i].getType() != DatasetType.POINT3D && datasetVectorArray[i].getType() != DatasetType.LINE3D && datasetVectorArray[i].getType() != DatasetType.REGION3D && datasetVectorArray[i].getType() != DatasetType.NETWORK3D) {
                String string = InternalResource.loadString("transformDatasets", "RecordsetDatasetTypeIsNotSupported", "data_resources");
                throw new IllegalArgumentException(string);
            }
            this._$1();
            if (TransformationNative.jni_TransformDirect(this.getHandle(), datasetVectorArray[i].getHandle(), this._$3.value(), this.m_selfEventHandle)) continue;
            bl = false;
        }
        this.clearSelfEventHandle();
        return bl;
    }

    public boolean transform(Geometry geometry) {
        if (geometry == null || InternalHandle.getHandle(geometry) == 0L) {
            String string = InternalResource.loadString("transformGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1();
        boolean bl = TransformationNative.jni_TransformGeometry(this.getHandle(), geometry.getHandle(), this._$3.value());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public boolean transform(Point2Ds point2Ds) {
        int n;
        if (point2Ds == null) {
            String string = InternalResource.loadString("transformPoint2Ds", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1();
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_TransformPoint2Ds(this.getHandle(), dArray, dArray2, this._$3.value()) ? 1 : 0;
        if (n != 0) {
            point2Ds.clear();
            for (int i = 0; i < n2; ++i) {
                Point2D point2D = new Point2D(dArray[i], dArray2[i]);
                point2Ds.add(point2D);
            }
        }
        return n != 0;
    }

    public boolean setOriginalControlPoints(Point2Ds point2Ds) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOriginalControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_SetOriginalControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this._$5.clear();
            this._$5.addRange(point2Ds.toArray());
        }
        return n != 0;
    }

    public Point2Ds getTargetControlPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public boolean setTargetControlPoints(Point2Ds point2Ds) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 1) {
            String string = InternalResource.loadString("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = point2Ds.getItem(n).getX();
            dArray2[n] = point2Ds.getItem(n).getY();
        }
        n = TransformationNative.jni_SetTargetControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n == 1) {
            this._$4.clear();
            this._$4.addRange(point2Ds.toArray());
        }
        return n != 0;
    }

    public TransformationMode getTransformMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setTransformMode(TransformationMode transformationMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (transformationMode == null) {
            String string = InternalResource.loadString("transformMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$3 = transformationMode;
    }

    public TransformationError getError() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getError()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = TransformationNative.jni_GetError(this.getHandle(), this._$3.value());
        if (l != 0L) {
            return new TransformationError(l);
        }
        return null;
    }

    protected void clearHandle() {
        this.setHandle(0L);
        if (this._$5 != null) {
            this._$5.clear();
            this._$5 = null;
        }
        if (this._$4 != null) {
            this._$4.clear();
            this._$4 = null;
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TransformationNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean fromSFCFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromSFCFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fileName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        int[] nArray = new int[1];
        if (string.trim().length() != 0 && (bl = TransformationNative.jni_FromSFCFile(this.getHandle(), string, nArray))) {
            int n;
            double[] dArray = new double[nArray[0]];
            double[] dArray2 = new double[nArray[0]];
            if (TransformationNative.jni_GetOriginalControlPoints(this.getHandle(), dArray, dArray2)) {
                this._$5.clear();
                for (n = 0; n < nArray[0]; ++n) {
                    this._$5.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
            if (TransformationNative.jni_GetTargetControlPoints(this.getHandle(), dArray, dArray2)) {
                this._$4.clear();
                for (n = 0; n < nArray[0]; ++n) {
                    this._$4.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
        }
        return bl;
    }

    public boolean toSFCFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toSFCFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fileName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        return TransformationNative.jni_ToSFCFile(this.getHandle(), string);
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("xml", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        int[] nArray = new int[2];
        if (string.trim().length() != 0 && (bl = TransformationNative.jni_FromXML(this.getHandle(), string, nArray))) {
            int n;
            this._$3 = (TransformationMode)Enum.parseUGCValue(TransformationMode.class, nArray[0]);
            double[] dArray = new double[nArray[1]];
            double[] dArray2 = new double[nArray[1]];
            if (TransformationNative.jni_GetOriginalControlPoints(this.getHandle(), dArray, dArray2)) {
                this._$5.clear();
                for (n = 0; n < nArray[1]; ++n) {
                    this._$5.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
            if (TransformationNative.jni_GetTargetControlPoints(this.getHandle(), dArray, dArray2)) {
                this._$4.clear();
                for (n = 0; n < nArray[1]; ++n) {
                    this._$4.add(new Point2D(dArray[n], dArray2[n]));
                }
            }
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TransformationNative.jni_ToXML(this.getHandle(), this._$3.value());
    }

    public String getTransformEquation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransformEquation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TransformationNative.jni_GetTransformEquation(this.getHandle());
    }

    private void _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Transformmation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null || this._$4 == null) {
            String string = InternalResource.loadString("ControlPoints", "Transformation_ControlPointsNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this._$5.getCount();
        int n2 = this._$4.getCount();
        if (n == 0 || n2 == 0) {
            String string = InternalResource.loadString("Transformmation", "Transformation_ControlPointsShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n != n2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_OriginalAndTargetControlPointsCountMustEqual", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == TransformationMode.RECT && n < 2) {
            String string = InternalResource.loadString("Transformmation", "Transformation_RectModeNeedLeastTwoControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == TransformationMode.LINEAR && n < 4) {
            String string = InternalResource.loadString("Transformmation", "Transformation_LinearModeNeedLeastFourControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == TransformationMode.SQUARE && n < 7) {
            String string = InternalResource.loadString("Transformmation", "Transformation_SquareModeNeedLeastSevenControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Transformation transformation, int n, long l, String string, String string2, long l2) {
        if (transformation != null) {
            String string3 = "Transformation";
            boolean bl = Toolkit.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent(transformation, n, l, string, string2, string3, bl);
            transformation.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            TransformationNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }
}

