/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarkerNative;
import com.supermap.data.SymbolMarkerStroke;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SymbolMarker
extends Symbol {
    private ArrayList<SymbolMarkerStroke> _$5;

    SymbolMarker(long l) {
        this.setHandle(l, false);
        this._$1(l);
    }

    private void _$1(long l) {
        Object object;
        int n;
        if (this._$5 != null) {
            for (n = 0; n < this._$5.size(); ++n) {
                object = this._$5.get(n);
                ((InternalHandle)object).clearHandle();
            }
            this._$5.clear();
        } else {
            this._$5 = new ArrayList();
        }
        n = SymbolMarkerNative.jni_GetStrokesCount(l);
        if (n > 0) {
            object = new long[n];
            SymbolMarkerNative.jni_GetStrokeHandle(l, (long[])object);
            for (int i = 0; i < n; ++i) {
                if (object[i] == 0L) continue;
                SymbolMarkerStroke symbolMarkerStroke = new SymbolMarkerStroke((long)object[i]);
                this._$5.add(symbolMarkerStroke);
            }
        }
    }

    public SymbolMarker() {
        long l = SymbolMarkerNative.jni_New();
        this.setHandle(l, true);
        this.setLibrary(null);
        this._$1(l);
    }

    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        if (geometry.getStyle() != null) {
            geometry2.setStyle(geometry.getStyle());
        }
        Rectangle2D rectangle2D = geometry2.getBounds();
        InternalBufferImage internalBufferImage = null;
        boolean bl = false;
        try {
            if (geometry2.getType().equals(GeometryType.GEOPOINT) && geometry2.getStyle() != null) {
                internalBufferImage = new InternalBufferImage((int)geometry2.getStyle().getMarkerSize().getWidth() + 10, (int)geometry2.getStyle().getMarkerSize().getHeight() + 10);
                geometry2.offset(-rectangle2D.getLeft() + geometry2.getStyle().getMarkerSize().getWidth() / 2.0 + 5.0, -rectangle2D.getBottom() + geometry2.getStyle().getMarkerSize().getHeight() / 2.0 + 5.0);
            } else {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 10, (int)rectangle2D.getHeight() + 10);
                geometry2.offset(-rectangle2D.getLeft() + 5.0, -rectangle2D.getBottom() + 5.0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        bl = SymbolMarkerNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry2.getHandle());
        if (bl) {
            if (geometry2.getType().equals(GeometryType.GEOPOINT)) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - internalBufferImage.getWidth() / 2, (int)rectangle2D.getBottom() - internalBufferImage.getHeight() / 2, null);
            } else {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 5, (int)rectangle2D.getBottom() - 5, null);
            }
        }
        internalBufferImage.makeSureNativeObjectLive();
        geometry2.makeSureNativeObjectLive();
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    public boolean draw(BufferedImage bufferedImage, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(bufferedImage.getGraphics(), geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public boolean draw(Graphics graphics, Point2Ds point2Ds, GeoStyle geoStyle) {
        InternalBufferImage internalBufferImage;
        Object object;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D();
        boolean bl = false;
        Point2Ds point2Ds2 = null;
        int n = point2Ds.getCount();
        try {
            if (n == 1) {
                object = point2Ds.getItem(0);
                rectangle2D = new Rectangle2D((Point2D)object, new Size2D(0.0, 0.0));
                internalBufferImage = new InternalBufferImage((int)geoStyle.getMarkerSize().getWidth() + 10, (int)geoStyle.getMarkerSize().getHeight() + 10);
                ((Point2D)object).offset(-rectangle2D.getLeft() + geoStyle.getMarkerSize().getWidth() / 2.0 + 5.0, -rectangle2D.getBottom() + geoStyle.getMarkerSize().getHeight() / 2.0 + 5.0);
                point2Ds2 = new Point2Ds();
                point2Ds2.add((Point2D)object);
            } else {
                object = new GeoLine(point2Ds);
                rectangle2D = ((Geometry)object).getBounds();
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 10, (int)rectangle2D.getHeight() + 10);
                ((GeoLine)object).offset(-rectangle2D.getLeft() + 5.0, -rectangle2D.getBottom() + 5.0);
                point2Ds2 = ((GeoLine)object).getPart(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        object = new double[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            object[i] = point2Ds2.getItem(i).getX();
            dArray[i] = point2Ds2.getItem(i).getY();
        }
        bl = geoStyle == null ? SymbolMarkerNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), (double[])object, dArray, 0L) : SymbolMarkerNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), (double[])object, dArray, geoStyle.getHandle());
        if (bl) {
            if (n == 1) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - internalBufferImage.getWidth() / 2, (int)rectangle2D.getBottom() - internalBufferImage.getHeight() / 2, null);
            } else {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 5, (int)rectangle2D.getBottom() - 5, null);
            }
        }
        internalBufferImage.makeSureNativeObjectLive();
        geoStyle.makeSureNativeObjectLive();
        return bl;
    }

    public boolean draw(BufferedImage bufferedImage, Point2Ds point2Ds, GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.draw(bufferedImage.getGraphics(), point2Ds, geoStyle);
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
        return bl;
    }

    public int computeDisplaySize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("computeDisplaySize(int symbolSize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeDisplaySize(this.getHandle(), n);
    }

    public int computeSymbolSize(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeSymbolSize(this.getHandle(), n);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public int fromGeometry(Geometry geometry, Rectangle2D rectangle2D) {
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geometry);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_FromGeometry(l, l2, rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        geometry.makeSureNativeObjectLive();
        this._$1(l);
        return this.getID();
    }

    public SymbolType getType() {
        return SymbolType.MARKER;
    }

    public Point getOrigin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOrigin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        SymbolMarkerNative.jni_GetOrigin(this.getHandle(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void setOrigin(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrigin(Point value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_SetOrigin(this.getHandle(), point.x, point.y);
    }

    public SymbolMarkerStroke get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this._$1(n);
        return this._$5.get(n);
    }

    private void _$1(int n) {
        SymbolMarkerNative.jni_GetMatrialStream(this.getHandle(), this.getLibrary().getLibPath(), n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5.size();
    }

    protected void clearHandle() {
        if (this._$5 != null) {
            for (int i = 0; i < this._$5.size(); ++i) {
                SymbolMarkerStroke symbolMarkerStroke = this._$5.get(i);
                symbolMarkerStroke.clearHandle();
            }
            this._$5.clear();
        }
        this.setHandle(0L);
    }
}

