/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalBufferImage;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolLineBase;
import com.supermap.data.SymbolLineNative;
import com.supermap.data.SymbolType;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SymbolLine
extends Symbol {
    protected SymbolLine(long l) {
        this.setHandle(l, false);
    }

    public boolean draw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOLINE) || geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOARC) || geometryType.equals(GeometryType.GEOLINEM) || geometryType.equals(GeometryType.GEOBSPLINE) || geometryType.equals(GeometryType.GEOCARDINAL) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOPIECYLINDER) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOELLIPTICARC) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE) || geometryType.equals(GeometryType.GEOCURVE) || geometryType.equals(GeometryType.GEOCHORD)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            int n = (int)rectangle2D.getLeft();
            int n2 = (int)rectangle2D.getBottom();
            geometry.offset(-n + 10, -n2 + 10);
            bl = SymbolLineNative.jni_Draw(this.getHandle(), internalBufferImage.getHandle(), geometry.getHandle());
            if (bl) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    public boolean draw(BufferedImage bufferedImage, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        geometry.makeSureNativeObjectLive();
        return this.draw(bufferedImage.getGraphics(), geometry);
    }

    public boolean draw(Graphics graphics, Point2Ds point2Ds, GeoStyle geoStyle) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(point2Ds);
        Rectangle2D rectangle2D = geoLine.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoLine.offset(-rectangle2D.getLeft() + 10.0, -rectangle2D.getBottom() + 10.0);
        Point2Ds point2Ds2 = geoLine.getPart(0);
        int n = point2Ds2.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds2.getItem(i).getX();
            dArray2[i] = point2Ds2.getItem(i).getY();
        }
        bl = geoStyle == null ? SymbolLineNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, 0L) : SymbolLineNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, geoStyle.getHandle());
        if (bl) {
            graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
        }
        internalBufferImage.makeSureNativeObjectLive();
        geoStyle.makeSureNativeObjectLive();
        return bl;
    }

    public boolean draw(BufferedImage bufferedImage, Point2Ds point2Ds, GeoStyle geoStyle) {
        InternalBufferImage internalBufferImage;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(BufferedImage image, Point2Ds points, GeoStyle style)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(point2Ds);
        Rectangle2D rectangle2D = geoLine.getBounds();
        boolean bl = false;
        try {
            internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        geoLine.offset(-rectangle2D.getLeft() + 10.0, -rectangle2D.getBottom() + 10.0);
        Point2Ds point2Ds2 = geoLine.getPart(0);
        int n = point2Ds2.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds2.getItem(i).getX();
            dArray2[i] = point2Ds2.getItem(i).getY();
        }
        bl = geoStyle == null ? SymbolLineNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, 0L) : SymbolLineNative.jni_Draw2(this.getHandle(), internalBufferImage.getHandle(), dArray, dArray2, geoStyle.getHandle());
        if (bl) {
            bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
        }
        internalBufferImage.makeSureNativeObjectLive();
        geoStyle.makeSureNativeObjectLive();
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public SymbolType getType() {
        return SymbolType.LINE;
    }

    protected boolean internalDraw(Graphics graphics, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        GeometryType geometryType = geometry.getType();
        if (geometryType.equals(GeometryType.GEOLINE) || geometryType.equals(GeometryType.GEOREGION) || geometryType.equals(GeometryType.GEOARC) || geometryType.equals(GeometryType.GEOLINEM) || geometryType.equals(GeometryType.GEOBSPLINE) || geometryType.equals(GeometryType.GEOCARDINAL) || geometryType.equals(GeometryType.GEOPIE) || geometryType.equals(GeometryType.GEOPIECYLINDER) || geometryType.equals(GeometryType.GEOROUNDRECTANGLE) || geometryType.equals(GeometryType.GEOELLIPTICARC) || geometryType.equals(GeometryType.GEOCIRCLE) || geometryType.equals(GeometryType.GEOELLIPSE) || geometryType.equals(GeometryType.GEORECTANGLE) || geometryType.equals(GeometryType.GEOCURVE) || geometryType.equals(GeometryType.GEOCHORD)) {
            InternalBufferImage internalBufferImage;
            Rectangle2D rectangle2D = geometry.getBounds();
            try {
                internalBufferImage = new InternalBufferImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            int n = (int)rectangle2D.getLeft();
            int n2 = (int)rectangle2D.getBottom();
            geometry.offset(-n + 10, -n2 + 10);
            bl = SymbolLineNative.jni_InternalDraw(this.getHandle(), internalBufferImage.getHandle(), geometry.getHandle());
            if (bl) {
                graphics.drawImage(internalBufferImage.getMemoryImage(), (int)rectangle2D.getLeft() - 10, (int)rectangle2D.getBottom() - 10, null);
            }
            internalBufferImage.makeSureNativeObjectLive();
        }
        geometry.makeSureNativeObjectLive();
        return bl;
    }

    protected static boolean internalDraw(SymbolLine symbolLine, Graphics graphics, Geometry geometry) {
        return symbolLine.internalDraw(graphics, geometry);
    }

    int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLineNative.jni_GetCount(this.getHandle());
    }

    SymbolLineBase get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n >= this.getCount() || n < 0) {
            return null;
        }
        long l = SymbolLineNative.jni_Get(this.getHandle(), n);
        if (l == 0L) {
            return null;
        }
        return new SymbolLineBase(l);
    }
}

