/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.MapAddedEvent;
import com.supermap.data.MapAddedListener;
import com.supermap.data.MapClearedEvent;
import com.supermap.data.MapClearedListener;
import com.supermap.data.MapClearingEvent;
import com.supermap.data.MapClearingListener;
import com.supermap.data.MapRemovedEvent;
import com.supermap.data.MapRemovedListener;
import com.supermap.data.MapRemovingEvent;
import com.supermap.data.MapRemovingListener;
import com.supermap.data.MapRenamedEvent;
import com.supermap.data.MapRenamedListener;
import com.supermap.data.MapRenamingEvent;
import com.supermap.data.MapRenamingListener;
import com.supermap.data.MapsNative;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceVersion;
import java.util.concurrent.CopyOnWriteArrayList;

public class Maps {
    private Workspace _$1;
    transient CopyOnWriteArrayList<MapRenamingListener> m_mapRenamingListeners;
    transient CopyOnWriteArrayList<MapRenamedListener> m_mapRenamedListeners;
    transient CopyOnWriteArrayList<MapRemovingListener> m_mapRemovingListeners;
    transient CopyOnWriteArrayList<MapRemovedListener> m_mapRemovedListeners;
    transient CopyOnWriteArrayList<MapAddedListener> m_mapAddedListeners;
    transient CopyOnWriteArrayList<MapClearingListener> m_mapClearingListeners;
    transient CopyOnWriteArrayList<MapClearedListener> m_mapClearedListeners;

    Maps(Workspace workspace) {
        this._$1 = workspace;
    }

    public int getCount() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MapsNative.jni_GetCount(this._$1.getHandle());
    }

    public String get(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetItem(this._$1.getHandle(), n);
    }

    public int add(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string5 = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        int n = -1;
        n = MapsNative.jni_Add(this._$1.getHandle(), string, string2);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, string);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public int add(String string, String string2, WorkspaceVersion workspaceVersion) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string5 = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        int n = -1;
        int n2 = workspaceVersion.value();
        n = MapsNative.jni_Add2(this._$1.getHandle(), string, string2, n2);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, string);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public boolean insert(int n, String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (n < 0 || n > this.getCount()) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string6 = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return MapsNative.jni_Insert(this._$1.getHandle(), n, string, string2);
    }

    public boolean insert(int n, String string, String string2, WorkspaceVersion workspaceVersion) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (n < 0 || n > this.getCount()) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string6 = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        int n2 = workspaceVersion.value();
        return MapsNative.jni_Insert2(this._$1.getHandle(), n, string, string2, n2);
    }

    public boolean setMapXML(int n, String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        return MapsNative.jni_SetMapXML(this._$1.getHandle(), n, string);
    }

    public boolean setMapXML(int n, String string, WorkspaceVersion workspaceVersion) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        int n2 = workspaceVersion.value();
        return MapsNative.jni_SetMapXML2(this._$1.getHandle(), n, string, n2);
    }

    public boolean setMapXML(String string, String string2) {
        int n;
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = this.indexOf(string)) == -1) {
            String string5 = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        return this.setMapXML(n, string2);
    }

    public boolean setMapXML(String string, String string2, WorkspaceVersion workspaceVersion) {
        int n;
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = this.indexOf(string)) == -1) {
            String string5 = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        return this.setMapXML(n, string2, workspaceVersion);
    }

    public String getMapXML(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetMapXML(this._$1.getHandle(), n);
    }

    public String getMapXML(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = this.indexOf(string);
        if (n == -1) {
            String string4 = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return MapsNative.jni_GetMapXML(this._$1.getHandle(), n);
    }

    public boolean remove(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(n);
        MapRemovingEvent mapRemovingEvent = new MapRemovingEvent(this, string);
        this.fireRemoving(mapRemovingEvent);
        if (mapRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Remove(this._$1.getHandle(), n);
        if (bl) {
            MapRemovedEvent mapRemovedEvent = new MapRemovedEvent(this, string);
            this.fireRemoved(mapRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        int n = this.indexOf(string);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MapClearingEvent mapClearingEvent = new MapClearingEvent(this);
        this.fireClearing(mapClearingEvent);
        if (mapClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        MapsNative.jni_Clear(this._$1.getHandle());
        MapClearedEvent mapClearedEvent = new MapClearedEvent(this, n);
        this.fireCleared(mapClearedEvent);
    }

    public int indexOf(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = MapsNative.jni_IndexOf(this._$1.getHandle(), string);
        }
        return n;
    }

    public String getAvailableMapName(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return MapsNative.jni_GetUnoccupiedMapName(this._$1.getHandle(), string);
    }

    public boolean rename(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.indexOf(string) == -1) {
            String string6 = InternalResource.loadString("oldName", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2.equalsIgnoreCase(string)) {
            return false;
        }
        if (this.indexOf(string2) >= 0) {
            String string7 = InternalResource.loadString("newName", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        MapRenamingEvent mapRenamingEvent = new MapRenamingEvent(this, string, string2);
        this.fireRenaming(mapRenamingEvent);
        if (mapRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Rename(this._$1.getHandle(), string, string2);
        if (bl) {
            MapRenamedEvent mapRenamedEvent = new MapRenamedEvent(this, string, string2);
            this.fireRenamed(mapRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this._$1 = null;
    }

    public synchronized void addRenamingListener(MapRenamingListener mapRenamingListener) {
        if (this.m_mapRenamingListeners == null) {
            this.m_mapRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRenamingListeners.contains(mapRenamingListener)) {
            this.m_mapRenamingListeners.add(mapRenamingListener);
        }
    }

    public void removeRenamingListener(MapRenamingListener mapRenamingListener) {
        if (this.m_mapRenamingListeners != null && this.m_mapRenamingListeners.contains(mapRenamingListener)) {
            this.m_mapRenamingListeners.remove(mapRenamingListener);
        }
    }

    protected void fireRenaming(MapRenamingEvent mapRenamingEvent) {
        if (this.m_mapRenamingListeners != null) {
            CopyOnWriteArrayList<MapRenamingListener> copyOnWriteArrayList = this.m_mapRenamingListeners;
            for (MapRenamingListener mapRenamingListener : copyOnWriteArrayList) {
                mapRenamingListener.mapRenaming(mapRenamingEvent);
            }
        }
    }

    public synchronized void addRenamedListener(MapRenamedListener mapRenamedListener) {
        if (this.m_mapRenamedListeners == null) {
            this.m_mapRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRenamedListeners.contains(mapRenamedListener)) {
            this.m_mapRenamedListeners.add(mapRenamedListener);
        }
    }

    public void removeRenamedListener(MapRenamedListener mapRenamedListener) {
        if (this.m_mapRenamedListeners != null && this.m_mapRenamedListeners.contains(mapRenamedListener)) {
            this.m_mapRenamedListeners.remove(mapRenamedListener);
        }
    }

    protected void fireRenamed(MapRenamedEvent mapRenamedEvent) {
        if (this.m_mapRenamedListeners != null) {
            CopyOnWriteArrayList<MapRenamedListener> copyOnWriteArrayList = this.m_mapRenamedListeners;
            for (MapRenamedListener mapRenamedListener : copyOnWriteArrayList) {
                mapRenamedListener.mapRenamed(mapRenamedEvent);
            }
        }
    }

    public synchronized void addRemovingListener(MapRemovingListener mapRemovingListener) {
        if (this.m_mapRemovingListeners == null) {
            this.m_mapRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRemovingListeners.contains(mapRemovingListener)) {
            this.m_mapRemovingListeners.add(mapRemovingListener);
        }
    }

    public void removeRemovingListener(MapRemovingListener mapRemovingListener) {
        if (this.m_mapRemovingListeners != null && this.m_mapRemovingListeners.contains(mapRemovingListener)) {
            this.m_mapRemovingListeners.remove(mapRemovingListener);
        }
    }

    protected void fireRemoving(MapRemovingEvent mapRemovingEvent) {
        if (this.m_mapRemovingListeners != null) {
            CopyOnWriteArrayList<MapRemovingListener> copyOnWriteArrayList = this.m_mapRemovingListeners;
            for (MapRemovingListener mapRemovingListener : copyOnWriteArrayList) {
                mapRemovingListener.mapRemoving(mapRemovingEvent);
            }
        }
    }

    public synchronized void addRemovedListener(MapRemovedListener mapRemovedListener) {
        if (this.m_mapRemovedListeners == null) {
            this.m_mapRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapRemovedListeners.contains(mapRemovedListener)) {
            this.m_mapRemovedListeners.add(mapRemovedListener);
        }
    }

    public void removeRemovedListener(MapRemovedListener mapRemovedListener) {
        if (this.m_mapRemovedListeners != null && this.m_mapRemovedListeners.contains(mapRemovedListener)) {
            this.m_mapRemovedListeners.remove(mapRemovedListener);
        }
    }

    protected void fireRemoved(MapRemovedEvent mapRemovedEvent) {
        if (this.m_mapRemovedListeners != null) {
            CopyOnWriteArrayList<MapRemovedListener> copyOnWriteArrayList = this.m_mapRemovedListeners;
            for (MapRemovedListener mapRemovedListener : copyOnWriteArrayList) {
                mapRemovedListener.mapRemoved(mapRemovedEvent);
            }
        }
    }

    public synchronized void addAddedListener(MapAddedListener mapAddedListener) {
        if (this.m_mapAddedListeners == null) {
            this.m_mapAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapAddedListeners.contains(mapAddedListener)) {
            this.m_mapAddedListeners.add(mapAddedListener);
        }
    }

    public void removeAddedListener(MapAddedListener mapAddedListener) {
        if (this.m_mapAddedListeners != null && this.m_mapAddedListeners.contains(mapAddedListener)) {
            this.m_mapAddedListeners.remove(mapAddedListener);
        }
    }

    protected void fireAdded(MapAddedEvent mapAddedEvent) {
        if (this.m_mapAddedListeners != null) {
            CopyOnWriteArrayList<MapAddedListener> copyOnWriteArrayList = this.m_mapAddedListeners;
            for (MapAddedListener mapAddedListener : copyOnWriteArrayList) {
                mapAddedListener.mapAdded(mapAddedEvent);
            }
        }
    }

    public synchronized void addClearingListener(MapClearingListener mapClearingListener) {
        if (this.m_mapClearingListeners == null) {
            this.m_mapClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapClearingListeners.contains(mapClearingListener)) {
            this.m_mapClearingListeners.add(mapClearingListener);
        }
    }

    public void removeClearingListener(MapClearingListener mapClearingListener) {
        if (this.m_mapClearingListeners != null && this.m_mapClearingListeners.contains(mapClearingListener)) {
            this.m_mapClearingListeners.remove(mapClearingListener);
        }
    }

    protected void fireClearing(MapClearingEvent mapClearingEvent) {
        if (this.m_mapClearingListeners != null) {
            CopyOnWriteArrayList<MapClearingListener> copyOnWriteArrayList = this.m_mapClearingListeners;
            for (MapClearingListener mapClearingListener : copyOnWriteArrayList) {
                mapClearingListener.mapClearing(mapClearingEvent);
            }
        }
    }

    public synchronized void addClearedListener(MapClearedListener mapClearedListener) {
        if (this.m_mapClearedListeners == null) {
            this.m_mapClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_mapClearedListeners.contains(mapClearedListener)) {
            this.m_mapClearedListeners.add(mapClearedListener);
        }
    }

    public void removeClearedListener(MapClearedListener mapClearedListener) {
        if (this.m_mapClearedListeners != null && this.m_mapClearedListeners.contains(mapClearedListener)) {
            this.m_mapClearedListeners.remove(mapClearedListener);
        }
    }

    protected void fireCleared(MapClearedEvent mapClearedEvent) {
        if (this.m_mapClearedListeners != null) {
            CopyOnWriteArrayList<MapClearedListener> copyOnWriteArrayList = this.m_mapClearedListeners;
            for (MapClearedListener mapClearedListener : copyOnWriteArrayList) {
                mapClearedListener.mapCleared(mapClearedEvent);
            }
        }
    }
}

