/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.LinkItem;
import com.supermap.data.LinkItemsNative;
import java.util.ArrayList;

public class LinkItems
extends InternalHandleDisposable {
    private ArrayList<LinkItem> _$3 = null;

    public LinkItems() {
        this._$3 = new ArrayList();
        this.setHandle(LinkItemsNative.jni_New(), true);
    }

    public LinkItems(LinkItem[] linkItemArray) {
        this();
        for (int i = 0; i < linkItemArray.length; ++i) {
            this.add(linkItemArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItemArray);
    }

    public LinkItems(LinkItems linkItems) {
        if (linkItems == null) {
            String string = InternalResource.loadString("linkItems", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (linkItems.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = LinkItemsNative.jni_Clone(linkItems.getHandle());
        this._$3 = new ArrayList();
        this.setHandle(l, true);
        int n = linkItems.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(linkItems.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
    }

    LinkItems(long l) {
        this._$3 = new ArrayList();
        this.setHandle(l, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3.size();
    }

    public LinkItem get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$3.get(n);
    }

    public void set(int n, LinkItem linkItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        LinkItemsNative.jni_Set(this.get(n).getHandle(), linkItem.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
    }

    public LinkItems clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new LinkItems(this);
    }

    public int add(LinkItem linkItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItem", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = LinkItemsNative.jni_Add(this.getHandle(), linkItem.getHandle());
        if (n != -1) {
            long l = LinkItemsNative.jni_Get(this.getHandle(), n);
            LinkItem linkItem2 = new LinkItem(l);
            this._$3.add(linkItem2);
            this.refreshHandle();
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return this.getCount() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
        return -1;
    }

    public int addRange(LinkItem[] linkItemArray) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = linkItemArray.length;
        for (n = 0; n < n3; ++n) {
            LinkItem linkItem = linkItemArray[n];
            if (linkItem == null) {
                String string = InternalResource.loadString("linkItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (linkItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("linkItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(linkItemArray[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItemArray);
        return n2;
    }

    public boolean insert(int n, LinkItem linkItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, LinkItem linkItem)", "LinkItems_SetLinkItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n == this.getCount()) {
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return this.add(linkItem) != -1;
        }
        long l = LinkItemsNative.jni_Insert(this.getHandle(), n, linkItem.getHandle());
        if (l == 0L) {
            InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
            return false;
        }
        LinkItem linkItem2 = new LinkItem(l);
        this._$3.add(n, linkItem2);
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
        return true;
    }

    public int insertRange(int n, LinkItem[] linkItemArray) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = linkItemArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            LinkItem linkItem = linkItemArray[n2];
            if (linkItem == null) {
                String string = InternalResource.loadString("linkItems[" + n2 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (linkItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("linkItems[" + n2 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            bl = this.insert(n + n2, linkItemArray[i]);
            if (!bl) continue;
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(linkItemArray);
        return n2;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        LinkItemsNative.jni_Remove(this.getHandle(), n);
        LinkItem linkItem = this.get(n);
        linkItem.clearHandle();
        this._$3.remove(n);
        return true;
    }

    public int removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 > this.getCount() - n) {
            String string = InternalResource.loadString("count", "LinkItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n + n2 - 1; i >= n; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n3;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public LinkItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$3.size();
        LinkItem[] linkItemArray = new LinkItem[n];
        for (int i = 0; i < n; ++i) {
            linkItemArray[i] = new LinkItem(this.get(i));
        }
        return linkItemArray;
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            LinkItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$3 != null) {
            int n = this._$3.size();
            for (int i = 0; i < n; ++i) {
                LinkItem linkItem = this.get(i);
                linkItem.clearHandle();
            }
            this._$3.clear();
            this._$3 = null;
        }
        this.setHandle(0L);
    }

    protected void refreshHandle() {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            LinkItem linkItem = this._$3.get(i);
            linkItem.clearHandle();
            long l = LinkItemsNative.jni_Get(this.getHandle(), i);
            this._$3.get(i).refreshHandle(l);
        }
    }
}

