/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.FillGradientMode;
import com.supermap.data.FillMode3D;
import com.supermap.data.GeoStyle3DNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MarkerBillboardMode;
import com.supermap.data.Point2D;
import com.supermap.data.TextureRepeatMode;
import com.supermap.data.Toolkit;
import java.awt.Color;

public class GeoStyle3D
extends InternalHandleDisposable {
    public GeoStyle3D() {
        super.setHandle(GeoStyle3DNative.jni_New(), true);
        this.reset();
    }

    public GeoStyle3D(GeoStyle3D geoStyle3D) {
        if (geoStyle3D.getHandle() == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoStyle3DNative.jni_Clone(geoStyle3D.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle3D);
    }

    GeoStyle3D(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public Color getFillForeColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyle3DNative.jni_GetFillForeColor(this.getHandle()), true);
        return color;
    }

    public void setFillForeColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetFillForeColor(this.getHandle(), color.getRGB());
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyle3DNative.jni_GetLineColor(this.getHandle()), true);
        return color;
    }

    public void setLineColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetLineColor(this.getHandle(), color.getRGB());
    }

    public double getLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetLineWidth(this.getHandle());
    }

    public void setLineWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheArgumentOfLineWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetLineWidth(this.getHandle(), d);
    }

    public String getMarkerFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetMarkerIconFile(this.getHandle());
    }

    public void setMarkerFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setMarkerFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        GeoStyle3DNative.jni_SetMarkerIconFile(this.getHandle(), string);
    }

    public double getMarkerScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerIconScale()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetMarkerIconScale(this.getHandle());
    }

    public void setMarkerScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerIconScale(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheArgumentOfMarkerIconScaleShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetMarkerIconScale(this.getHandle(), d);
    }

    public Color getMarkerColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyle3DNative.jni_GetMarkerColor(this.getHandle()), true);
        return color;
    }

    public void setMarkerColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetMarkerColor(this.getHandle(), color.getRGB());
    }

    public double getMarkerSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetMarkerSize(this.getHandle());
    }

    public void setMarkerSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheValueOfMarkerSizeShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetMarkerSize(this.getHandle(), d);
    }

    public FillMode3D getFillMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFill3DMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyle3DNative.jni_GetFill3DMode(this.getHandle());
        return (FillMode3D)Enum.parseUGCValue(FillMode3D.class, n);
    }

    public void setFillMode(FillMode3D fillMode3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFill3DMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fillMode3D == null) {
            String string = InternalResource.loadString("fillGradientMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = fillMode3D.getUGCValue();
        GeoStyle3DNative.jni_SetFill3DMode(this.getHandle(), n);
    }

    public double getBottomAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomAltitude()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetBottomAltitude(this.getHandle());
    }

    public void setBottomAltitude(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomAltitude(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetBottomAltitude(this.getHandle(), d);
    }

    public double getExtendedHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtendedHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetExtendedHeight(this.getHandle());
    }

    public void setExtendedHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtendedHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetExtendedHeight(this.getHandle(), d);
    }

    public String[] getSideTextureFiles() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSideTextureFiles()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoStyle3DNative.jni_GetSideTextureFiles(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setSideTextureFiles(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSideTextureFiles(String[] value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        GeoStyle3DNative.jni_SetSideTextureFiles(this.getHandle(), string);
    }

    public double getTilingU() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingU()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTilingU(this.getHandle());
    }

    public void setTilingU(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingU(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheValueOfTilingUShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTilingU(this.getHandle(), d);
    }

    public double getTilingV() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingV()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTilingV(this.getHandle());
    }

    public void setTilingV(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingV(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheValueOfTilingVShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTilingV(this.getHandle(), d);
    }

    public double getTopTilingU() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopTilingU()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTopTilingU(this.getHandle());
    }

    public void setTopTilingU(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopTilingU(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheValueOfTopTilingUShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTopTilingU(this.getHandle(), d);
    }

    public double getTopTilingV() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopTilingV()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTopTilingV(this.getHandle());
    }

    public void setTopTilingV(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopTilingV(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle3D_TheValueOfTopTilingVShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTopTilingV(this.getHandle(), d);
    }

    public TextureRepeatMode getTextureRepeatMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextureRepeatMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyle3DNative.jni_GetTextureRepeatMode(this.getHandle());
        return (TextureRepeatMode)Enum.parseUGCValue(TextureRepeatMode.class, n);
    }

    public void setTextureRepeatMode(TextureRepeatMode textureRepeatMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextureRepeatMode(TextureRepeatMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = textureRepeatMode.getUGCValue();
        GeoStyle3DNative.jni_SetTextureRepeatMode(this.getHandle(), n);
    }

    public TextureRepeatMode getTopTextureRepeatMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopTextureRepeatMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyle3DNative.jni_GetTopTextureRepeatMode(this.getHandle());
        return (TextureRepeatMode)Enum.parseUGCValue(TextureRepeatMode.class, n);
    }

    public void setTopTextureRepeatMode(TextureRepeatMode textureRepeatMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopTextureRepeatMode(TextureRepeatMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = textureRepeatMode.getUGCValue();
        GeoStyle3DNative.jni_SetTopTextureRepeatMode(this.getHandle(), n);
    }

    public String getTopTextureFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopTextureFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTopTextureFile(this.getHandle());
    }

    public void setTopTextureFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setTopTextureFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        GeoStyle3DNative.jni_SetTopTextureFile(this.getHandle(), string);
    }

    public AltitudeMode getAltitudeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAltitudeMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyle3DNative.jni_GetAltitudeMode(this.getHandle());
        return (AltitudeMode)Enum.parseUGCValue(AltitudeMode.class, n);
    }

    public void setAltitudeMode(AltitudeMode altitudeMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAltitudeMode(AltitudeMode mode)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = altitudeMode.getUGCValue();
        GeoStyle3DNative.jni_SetAltitudeMode(this.getHandle(), n);
    }

    public GeoStyle3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoStyle3D(this);
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            GeoStyle3DNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{FillForeColor = ");
        stringBuffer.append(this.getFillForeColor().toString());
        stringBuffer.append(",LineColor = ");
        stringBuffer.append(this.getLineColor().toString());
        stringBuffer.append(",LineWidth = ");
        stringBuffer.append(this.getLineWidth());
        stringBuffer.append(",MarkerIconFile = ");
        stringBuffer.append(this.getMarkerFile());
        stringBuffer.append(",MarkerIconScale = ");
        stringBuffer.append(this.getMarkerScale());
        stringBuffer.append(",MarkerColor = ");
        stringBuffer.append(this.getMarkerColor());
        stringBuffer.append(",MarkerSize = ");
        stringBuffer.append(this.getMarkerSize());
        stringBuffer.append(",Fill3DMode = ");
        stringBuffer.append(this.getFillMode().name());
        stringBuffer.append(",BottomAltitude = ");
        stringBuffer.append(this.getBottomAltitude());
        stringBuffer.append(",ExtendedHeight = ");
        stringBuffer.append(this.getExtendedHeight());
        stringBuffer.append(",TilingU = ");
        stringBuffer.append(this.getTilingU());
        stringBuffer.append(",TilingV = ");
        stringBuffer.append(this.getTilingV());
        stringBuffer.append(",TopTilingU = ");
        stringBuffer.append(this.getTopTilingU());
        stringBuffer.append(",TopTilingV = ");
        stringBuffer.append(this.getTopTilingV());
        stringBuffer.append(",TopTextureFile = ");
        stringBuffer.append(this.getTopTextureFile());
        stringBuffer.append(",AltitudeMode = ");
        stringBuffer.append(this.getAltitudeMode());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoStyle3DNative.jni_ToXML(this.getHandle());
        return string;
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = GeoStyle3DNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    protected static void changeHandle(GeoStyle3D geoStyle3D, long l) {
        geoStyle3D._$2(l);
    }

    protected static void refreshHandle(GeoStyle3D geoStyle3D, long l) {
        geoStyle3D._$1(l);
    }

    protected static GeoStyle3D createInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoStyle3D(l);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoStyle3D geoStyle3D) {
        geoStyle3D.clearHandle();
    }

    protected static void reset(GeoStyle3D geoStyle3D) {
        geoStyle3D.reset();
    }

    void reset() {
        if (this.getHandle() != 0L) {
            GeoStyle3DNative.jni_Reset(this.getHandle());
        }
    }

    private void _$2(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            GeoStyle3DNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }

    private void _$1(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public MarkerBillboardMode getMarkerBillboardMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerBillboardMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyle3DNative.jni_GetAltitudeMode(this.getHandle());
        return (MarkerBillboardMode)Enum.parseUGCValue(MarkerBillboardMode.class, n);
    }

    public void setMarkerBillboardMode(MarkerBillboardMode markerBillboardMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerBillboardMode(MarkerBillboardMode value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = markerBillboardMode.getUGCValue();
        GeoStyle3DNative.jni_SetMarkerBillboardMode(this.getHandle(), n);
    }

    public boolean isMarkerSizeFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMarkerSizeFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetIsMarkerSizeFixed(this.getHandle());
    }

    public void setMarkerSizeFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerSizeFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetMarkerSizeFixed(this.getHandle(), bl);
    }

    public int getMarkerSymbolID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerSymbolID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetMarkerSymbolID(this.getHandle());
    }

    public void setMarkerSymbolID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerSymbolID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "MarkerSymbolID_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetMarkerSymbolID(this.getHandle(), n);
    }

    public boolean isMarker3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMarker3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_IsMarker3D(this.getHandle());
    }

    public void setMarker3D(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3D(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetMarker3D(this.getHandle(), bl);
    }

    public int getLineSymbolID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineSymbolID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetLineSymbolID(this.getHandle());
    }

    public void setLineSymbolID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineSymbolID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "LineSymbolID_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetLineSymbolID(this.getHandle(), n);
    }

    public double getMarker3DRotateX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DRotateX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolRotationX(this.getHandle());
    }

    public void setMarker3DRotateX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3DRotateX(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Marker3DRotationX_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolRotationX(this.getHandle(), d);
    }

    public double getMarker3DRotateY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DRotateY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolRotationY(this.getHandle());
    }

    public void setMarker3DRotateY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DRotateY(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Marker3DRotationY_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolRotationY(this.getHandle(), d);
    }

    public double getMarker3DRotateZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DRotateZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolRotationZ(this.getHandle());
    }

    public void setMarker3DRotateZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3DRotateZ(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Marker3DRotationZ_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolRotationZ(this.getHandle(), d);
    }

    public double getMarker3DScaleX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DScaleX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolScaleX(this.getHandle());
    }

    public void setMarker3DScaleX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3DScaleX(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Marker3DScaleX_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolScaleX(this.getHandle(), d);
    }

    public double getMarker3DScaleY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DScaleY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolScaleY(this.getHandle());
    }

    public void setMarker3DScaleY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3DScaleY(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Marker3DScaleY_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolScaleY(this.getHandle(), d);
    }

    public double getMarker3DScaleZ() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarker3DScaleZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSymbolScaleZ(this.getHandle());
    }

    public void setMarker3DScaleZ(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarker3DScaleZ(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Maker3DScaleZ_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetSymbolScaleZ(this.getHandle(), d);
    }

    private int _$3() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineSymbolSegmentCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetLineSymbolSegmentCount(this.getHandle());
    }

    private void _$2(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineSymbolSegmentCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "LineSymbolSegmentCount_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetLineSymbolSegmentCount(this.getHandle(), n);
    }

    public Point2D getMarkerAnchorPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMarkerAnchorPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoStyle3DNative.jni_GetMarkerAnchorPoint(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setMarkerAnchorPoint(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMarkerAnchorPoint(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetMarkerAnchorPoint(this.getHandle(), point2D.getX(), point2D.getY());
    }

    private int _$2() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTopFillSymbolID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTopFillSymbolID(this.getHandle());
    }

    private void _$1(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTopFillSymbolID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "TopFillSymbolID_ShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTopFillSymbolID(this.getHandle(), n);
    }

    private int[] _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSideFillSymbolIDs()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetSideFillSymbolIDs(this.getHandle());
    }

    private void _$1(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSideFillSymbolIDs(int[] value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetSideFillSymbolIDs(this.getHandle(), nArray);
    }

    public int getTubeSides() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTubeSides()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_GetTubeSides(this.getHandle());
    }

    public void setTubeSides(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTubeSides(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "TubeSidesCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3DNative.jni_SetTubeSides(this.getHandle(), n);
    }

    public boolean isFiletEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFiletEnabled()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_IsFiletEnabled(this.getHandle());
    }

    public void setFiletEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFiletEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetFiletEnabled(this.getHandle(), bl);
    }

    public boolean isTessellated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTessellated()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyle3DNative.jni_IsTessellated(this.getHandle());
    }

    public void setTessellated(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTessellated(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyle3DNative.jni_SetTessellated(this.getHandle(), bl);
    }

    public void setFillSymbolID(int n) {
    }

    public int getFillSymbolID() {
        return 0;
    }

    public void setFillBackColor(Color color) {
    }

    public Color getFillBackColor() {
        Color color = new Color(GeoStyle3DNative.jni_GetFillForeColor(this.getHandle()), true);
        return color;
    }

    public void setFillGradientAngle(double d) {
    }

    public double getFillGradientAngle() {
        return 0.0;
    }

    public void setFillGradientOffsetRatioX(int n) {
    }

    public int getFillGradientOffsetRatioX() {
        return 0;
    }

    public void setFillGradientOffsetRatioY(int n) {
    }

    public int getFillGradientOffsetRatioY() {
        return 0;
    }

    public void setFillGradientMode(FillGradientMode fillGradientMode) {
    }

    public FillGradientMode getFillGradientMode() {
        int n = 0;
        return (FillGradientMode)Enum.parseUGCValue(FillGradientMode.class, n);
    }
}

