/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.FillGradientMode;
import com.supermap.data.GeoStyleNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Size2D;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolMarker;
import java.awt.Color;

public class GeoStyle
extends InternalHandleDisposable {
    public GeoStyle() {
        super.setHandle(GeoStyleNative.jni_New(), true);
        this.reset();
    }

    public GeoStyle(GeoStyle geoStyle) {
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoStyleNative.jni_Clone(geoStyle.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    GeoStyle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public Color getFillBackColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetFillBackColor(this.getHandle()));
        return color;
    }

    public void setFillBackColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillBackColor(this.getHandle(), color.getRGB());
    }

    public boolean getFillBackOpaque() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetIsBackTransparent(this.getHandle());
    }

    public void setFillBackOpaque(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetIsBackTransparent(this.getHandle(), bl);
    }

    public Color getFillForeColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetFillForeColor(this.getHandle()));
        return color;
    }

    public void setFillForeColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillForeColor(this.getHandle(), color.getRGB());
    }

    public double getFillGradientAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillAngle(this.getHandle());
    }

    public void setFillGradientAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillAngle(this.getHandle(), d);
    }

    public double getFillGradientOffsetRatioX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillCenterOffsetX(this.getHandle());
    }

    public void setFillGradientOffsetRatioX(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillCenterOffsetX(this.getHandle(), d);
    }

    public double getFillGradientOffsetRatioY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillCenterOffsetY(this.getHandle());
    }

    public void setFillGradientOffsetRatioY(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillCenterOffsetY(this.getHandle(), d);
    }

    public FillGradientMode getFillGradientMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoStyleNative.jni_GetFillGradientType(this.getHandle());
        return (FillGradientMode)Enum.parseUGCValue(FillGradientMode.class, n);
    }

    public void setFillGradientMode(FillGradientMode fillGradientMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fillGradientMode == null) {
            String string = InternalResource.loadString("fillGradientMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = fillGradientMode.getUGCValue();
        GeoStyleNative.jni_SetFillGradientType(this.getHandle(), n);
    }

    public int getFillOpaqueRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillOpaqueRate(this.getHandle());
    }

    public void setFillOpaqueRate(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        n = n < 0 ? 0 : n;
        n = n > 100 ? 100 : n;
        GeoStyleNative.jni_SetFillOpaqueRate(this.getHandle(), n);
    }

    public int getFillSymbolID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillStyle(this.getHandle());
    }

    public void setFillSymbolID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "GeoStyle_TheValueOfSymbolIDShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetFillStyle(this.getHandle(), n);
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetLineColor(this.getHandle()));
        return color;
    }

    public void setLineColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetLineColor(this.getHandle(), color.getRGB());
    }

    public int getLineSymbolID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetLineStyle(this.getHandle());
    }

    public void setLineSymbolID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "GeoStyle_TheValueOfSymbolIDShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetLineStyle(this.getHandle(), n);
    }

    public double getLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetLineWidth(this.getHandle());
    }

    public void setLineWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyle_TheArgumentOfLineWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetLineWidth(this.getHandle(), d);
    }

    public double getMarkerAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetMarkerAngle(this.getHandle());
    }

    public void setMarkerAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetMarkerAngle(this.getHandle(), d);
    }

    public Size2D getMarkerSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoStyleNative.jni_GetMarkerSize(this.getHandle(), dArray);
        if (dArray[0] < 0.0 || dArray[1] < 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        }
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setMarkerSize(Size2D size2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (size2D.getWidth() < 0.0 && size2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("value", "GeoStyleTheValueOfMarkerSize_IsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetMarkerSize(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public int getMarkerSymbolID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetMarkerStyle(this.getHandle());
    }

    public void setMarkerSymbolID(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetMarkerStyle(this.getHandle(), n);
    }

    public GeoStyle clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoStyle(this);
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            GeoStyleNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{FillBackColor = ");
        stringBuffer.append(this.getFillBackColor().toString());
        stringBuffer.append(",FillForeColor = ");
        stringBuffer.append(this.getFillForeColor().toString());
        stringBuffer.append(",FillGradientAngle = ");
        stringBuffer.append(this.getFillGradientAngle());
        stringBuffer.append(",FillGradientOffsetRatioX = ");
        stringBuffer.append(this.getFillGradientOffsetRatioX());
        stringBuffer.append(",FillGradientOffsetRatioY = ");
        stringBuffer.append(this.getFillGradientOffsetRatioY());
        stringBuffer.append(",FillGradientMode = ");
        stringBuffer.append(this.getFillGradientMode().name());
        stringBuffer.append(",FillOpaqueRate = ");
        stringBuffer.append(this.getFillOpaqueRate());
        stringBuffer.append(",FillSymbolID = ");
        stringBuffer.append(this.getFillSymbolID());
        stringBuffer.append(",LineColor = ");
        stringBuffer.append(this.getLineColor().toString());
        stringBuffer.append(",LineSymbolID = ");
        stringBuffer.append(this.getLineSymbolID());
        stringBuffer.append(",LineWidth = ");
        stringBuffer.append(this.getLineWidth());
        stringBuffer.append(",MarkerAngle = ");
        stringBuffer.append(this.getMarkerAngle());
        stringBuffer.append(",MarkerSize = ");
        stringBuffer.append(this.getMarkerSize());
        stringBuffer.append(",MarkerSymbolID = ");
        stringBuffer.append(this.getMarkerSymbolID());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public SymbolMarker getSymbolMarker() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolMarker()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarker symbolMarker = null;
        long l = GeoStyleNative.jni_GetSymbolMarker(this.getHandle());
        if (l != 0L) {
            symbolMarker = new SymbolMarker(l);
            symbolMarker.setIsDisposable(true);
        }
        return symbolMarker;
    }

    public void setSymbolMarker(SymbolMarker symbolMarker) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolMarker(SymbolMarker symbolMarker))", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (symbolMarker != null) {
            if (symbolMarker.getHandle() == 0L) {
                String string = InternalResource.loadString("symbolMarker", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            l = symbolMarker.getHandle();
        }
        GeoStyleNative.jni_SetSymbolMarker(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(symbolMarker);
    }

    public SymbolLine getSymbolLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLine symbolLine = null;
        long l = GeoStyleNative.jni_GetSymbolLine(this.getHandle());
        if (l != 0L) {
            symbolLine = new SymbolLine(l);
            symbolLine.setIsDisposable(true);
        }
        return symbolLine;
    }

    public void setSymbolLine(SymbolLine symbolLine) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolLine(SymbolLine symbolLine)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (symbolLine != null) {
            if (symbolLine.getHandle() == 0L) {
                String string = InternalResource.loadString("symbolLine", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            l = symbolLine.getHandle();
        }
        GeoStyleNative.jni_SetSymbolLine(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(symbolLine);
    }

    public SymbolFill getSymbolFill() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolFill symbolFill = null;
        long l = GeoStyleNative.jni_GetSymbolFill(this.getHandle());
        if (l != 0L) {
            symbolFill = new SymbolFill(l);
            symbolFill.setIsDisposable(true);
        }
        return symbolFill;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoStyleNative.jni_ToXML(this.getHandle());
        return string;
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = GeoStyleNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public void setSymbolFill(SymbolFill symbolFill) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolFill(SymbolFill symbolFill)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (symbolFill != null) {
            if (symbolFill.getHandle() == 0L) {
                String string = InternalResource.loadString("symbolFill", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            l = symbolFill.getHandle();
        }
        GeoStyleNative.jni_SetSymbolFill(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive(symbolFill);
    }

    protected static void changeHandle(GeoStyle geoStyle, long l) {
        geoStyle._$2(l);
    }

    protected static void refreshHandle(GeoStyle geoStyle, long l) {
        geoStyle._$1(l);
    }

    protected static GeoStyle createInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoStyle(l);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoStyle geoStyle) {
        geoStyle.clearHandle();
    }

    protected static void reset(GeoStyle geoStyle) {
        geoStyle.reset();
    }

    void reset() {
        if (this.getHandle() != 0L) {
            GeoStyleNative.jni_Reset(this.getHandle());
        }
    }

    private void _$2(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            GeoStyleNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }

    private void _$1(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }
}

