/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPyramidNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Size2D;

public class GeoPyramid
extends Geometry3D {
    public GeoPyramid() {
        long l = GeoPyramidNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPyramid(GeoPyramid geoPyramid) {
        if (geoPyramid == null) {
            String string = InternalResource.loadString("geoPyramid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoPyramid);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPyramid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPyramidNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPyramid);
    }

    public GeoPyramid(Point3D point3D, Size2D size2D, double d) {
        double d2 = point3D.getX();
        double d3 = point3D.getY();
        double d4 = point3D.getZ();
        double d5 = size2D.getHeight();
        double d6 = size2D.getWidth();
        if (d6 <= 0.0) {
            String string = InternalResource.loadString("bottomSize.getWidth()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d5 <= 0.0) {
            String string = InternalResource.loadString("bottomSize.getHeight()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("height", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPyramidNative.jni_New2(d2, d3, d4, d6, d5, d);
        this.setHandle(l, true);
    }

    GeoPyramid(long l) {
        this.setHandle(l, false);
    }

    public Size2D getBottomSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoPyramidNative.jni_GetBottomSize(this.getHandle(), dArray);
        Size2D size2D = new Size2D();
        size2D.setWidth(dArray[0]);
        size2D.setHeight(dArray[1]);
        return size2D;
    }

    public void setBottomSize(Size2D size2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomSize(Size2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = size2D.getWidth();
        if (d <= 0.0) {
            String string = InternalResource.loadString("value.getWidth()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = size2D.getHeight();
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("value.getHeight()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPyramidNative.jni_SetBottomSize(this.getHandle(), d, d2);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPyramidNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPyramid_HeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPyramidNative.jni_SetHeight(this.getHandle(), d);
    }

    public GeoPyramid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPyramid(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPyramidNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }
}

