/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Dataset;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.Toolkit;
import com.supermap.data.Workspace;
import com.supermap.data.conversion.InternalHandleDisposable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InternalToolkiConversion
extends Toolkit {
    static double DBL_MAX_VALUE = Double.MAX_VALUE;
    static double DBL_MIN_VALUE = -1.7976931348623157E308;
    static float FLT_MAX_VALUE = Float.MAX_VALUE;
    static float FLT_MIN_VALUE = -3.4028235E38f;

    protected static void setHandleBooleanValue(long l, boolean bl) {
        Toolkit.setHandleBooleanValue((long)l, (boolean)bl);
    }

    protected static boolean getHandleBooleanValue(long l) {
        return Toolkit.getHandleBooleanValue((long)l);
    }

    protected static Dataset toMangedDataset(Workspace workspace, long l) {
        Dataset dataset = Toolkit.toManageDataset((Workspace)workspace, (long)l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
        return dataset;
    }

    protected static String[] splitString(String string, String string2) {
        return Toolkit.splitString((String)string, (String)string2);
    }

    protected static String joinString(String[] stringArray, String string) {
        return Toolkit.joinString((String[])stringArray, (String)string);
    }

    protected static License verifyLicense(ArrayList<ProductType> arrayList) {
        return Toolkit.verifyLicense(arrayList);
    }

    protected static ArrayList<ProductType> managerProducts(ArrayList<ProductType> arrayList) {
        return Toolkit.managerProducts(arrayList);
    }

    protected static ArrayList<ProductType> getConversionProducts() {
        return Toolkit.getConversionProducts();
    }

    protected static ArrayList<ProductType> getFMEVectorProducts() {
        return Toolkit.getFMEVectorProducts();
    }

    protected static ArrayList<ProductType> getFMEEsriProducts() {
        return Toolkit.getFMEEsriProducts();
    }

    protected static ArrayList<ProductType> getFMERasterProducts() {
        return Toolkit.getFMERasterProducts();
    }

    protected static ArrayList<ProductType> getFMEOtherProducts() {
        return Toolkit.getFMEOtherProducts();
    }

    protected static int GetFMELicenseCode(ArrayList<ProductType> arrayList) {
        ProductType productType;
        int n = -1;
        License license = new License();
        Iterator<ProductType> iterator = arrayList.iterator();
        while (iterator.hasNext() && (n = license.connect(productType = iterator.next())) != 0) {
        }
        if (n == 0) {
            n = license.verify();
        }
        return n;
    }
}

