/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.AddressMatchSetting;
import com.supermap.analyst.addressmatching.EnglishAddressMatchResults;
import com.supermap.analyst.addressmatching.EnglishAddressReverseMatchResults;
import com.supermap.analyst.addressmatching.InternalDatasetVector;
import com.supermap.analyst.addressmatching.InternalDatasets;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import java.util.ArrayList;

class EnglishAddressMatch
extends InternalHandleDisposable {
    private AddressMatchSetting _$5;
    private boolean _$4;
    private boolean _$3;
    private License _$2;
    private long _$1;

    public EnglishAddressMatch() {
        this._$5();
        long l = AddressMatchNative.jni_EngNew();
        this.setHandle(l, true);
        this._$5 = new AddressMatchSetting();
        this._$4 = false;
        this._$3 = false;
        this._$1 = 0L;
    }

    private void _$5() {
        ArrayList<ProductType> arrayList = InternalToolkitAddressMatching.managerProducts(InternalToolkitAddressMatching.getAddressMatchingProducts());
        this._$2 = InternalToolkitAddressMatching.verifyLicense(arrayList);
    }

    private void _$4() {
        if (this._$2 != null) {
            this._$2.disconnect();
            this._$2.dispose();
            this._$2 = null;
        }
    }

    private void _$3() {
        int n = this._$2.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this._$4();
        if (this.getHandle() != 0L) {
            AddressMatchNative.jni_EngDelete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
        this._$4 = false;
    }

    protected void clearHandle() {
        if (this._$5 != null) {
            this._$5 = null;
        }
    }

    public boolean buildDicTree(AddressMatchSetting addressMatchSetting) {
        this._$3();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildDicTree()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (addressMatchSetting == null) {
            String string = InternalResource.loadString("AddressMatchSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        DatasetVector datasetVector = addressMatchSetting.getKeyDT();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        DatasetVector datasetVector2 = addressMatchSetting.getRefDT();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
        String[] stringArray = addressMatchSetting.getRefNames();
        String string = addressMatchSetting.getCLSAbField();
        String string2 = addressMatchSetting.getCLSWordField();
        String string3 = addressMatchSetting.getCLSTypeField();
        String string4 = "DtIndex_temp";
        if (datasetVector.getDatasource().getDatasets().contains(string4)) {
            datasetVector.getDatasource().getDatasets().delete(string4);
        }
        int n = addressMatchSetting.getMinMatchScore();
        double d = addressMatchSetting.getOffset();
        double d2 = addressMatchSetting.getEndOffset();
        int n2 = 1;
        bl = AddressMatchNative.jni_BuildDicTree(this.getHandle(), l, l2, stringArray, string, string2, string3, string4, n, d, d2, n2);
        if (bl) {
            this._$4 = true;
        }
        return bl;
    }

    public EnglishAddressMatchResults match(String string, String string2) {
        this._$3();
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("match", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string3);
        }
        if (!this._$1()) {
            String string4 = InternalResource.loadString("m_isLoaded", "AddressMatch_LoadNeeded", "addressmatching_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("addressFieldName", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string5);
        }
        EnglishAddressMatchResults englishAddressMatchResults = new EnglishAddressMatchResults();
        boolean bl = AddressMatchNative.jni_EngMatch(this.getHandle(), com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)englishAddressMatchResults), string, string2);
        return englishAddressMatchResults;
    }

    public EnglishAddressMatchResults match(DatasetVector datasetVector, String string, String string2, String string3) {
        this._$3();
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("match", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string4);
        }
        if (!this._$1()) {
            String string5 = InternalResource.loadString("m_isLoaded", "AddressMatch_LoadNeeded", "addressmatching_resources");
            throw new IllegalStateException(string5);
        }
        if (datasetVector == null) {
            String string6 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("addressFieldName", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string7);
        }
        if (string3 == null || string3.trim().length() == 0) {
            String string8 = InternalResource.loadString("outputName", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string8);
        }
        if (datasetVector.getDatasource().getDatasets().contains(string3)) {
            datasetVector.getDatasource().getDatasets().delete(string3);
        }
        EnglishAddressMatchResults englishAddressMatchResults = new EnglishAddressMatchResults();
        long l2 = AddressMatchNative.jni_EngMatchBatch(this.getHandle(), l, com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)englishAddressMatchResults), string, string2, string3);
        if (l2 == 0L) {
            return null;
        }
        DatasetVector datasetVector2 = InternalDatasetVector.createInstance(l2, datasetVector.getDatasource());
        InternalDatasets.add(datasetVector.getDatasource().getDatasets(), (Dataset)datasetVector2);
        return englishAddressMatchResults;
    }

    public EnglishAddressReverseMatchResults reverseCode(DatasetVector datasetVector, double d) {
        boolean bl;
        this._$3();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reCode", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$1()) {
            String string = InternalResource.loadString("m_isLoaded", "AddressMatch_LoadNeeded", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentTypeInvalid", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        this._$3 = bl = AddressMatchNative.jni_EngReCode(this.getHandle(), l, d);
        EnglishAddressReverseMatchResults englishAddressReverseMatchResults = null;
        if (bl) {
            long l2 = this._$2();
            englishAddressReverseMatchResults = new EnglishAddressReverseMatchResults();
            englishAddressReverseMatchResults.setCount(l2);
            int n = 0;
            while ((long)n < l2) {
                String[] stringArray = new String[10];
                long[] lArray = new long[10];
                double[] dArray = new double[10];
                this._$1(n, stringArray, lArray, dArray);
                englishAddressReverseMatchResults.set(n, stringArray, lArray, dArray);
                ++n;
            }
        }
        return englishAddressReverseMatchResults;
    }

    private long _$2() {
        if (!this._$3) {
            return 0L;
        }
        this._$1 = AddressMatchNative.jni_EngPntCount(this.getHandle());
        return this._$1;
    }

    private void _$1(int n, String[] stringArray, long[] lArray, double[] dArray) {
        if (!this._$3 || (long)n > this._$1 - 1L) {
            return;
        }
        AddressMatchNative.jni_EngPntLoc(this.getHandle(), n, stringArray, lArray, dArray);
    }

    private boolean _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadNeeded()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this._$5.isChanged() || !this._$4;
    }
}

