/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.ClientInfo;
import org.restlet.engine.security.RoleMapping;
import org.restlet.security.Enroler;
import org.restlet.security.Group;
import org.restlet.security.Realm;
import org.restlet.security.Role;
import org.restlet.security.SecretVerifier;
import org.restlet.security.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryRealm
extends Realm {
    private final List<RoleMapping> roleMappings;
    private final List<Group> rootGroups;
    private final List<User> users;

    public MemoryRealm() {
        this.setVerifier(new DefaultVerifier());
        this.setEnroler(new DefaultEnroler());
        this.rootGroups = new CopyOnWriteArrayList<Group>();
        this.roleMappings = new CopyOnWriteArrayList<RoleMapping>();
        this.users = new CopyOnWriteArrayList<User>();
    }

    private void addGroups(User user, Set<Group> userGroups, Group currentGroup, List<Group> stack, boolean inheritOnly) {
        if (currentGroup != null && !stack.contains(currentGroup)) {
            stack.add(currentGroup);
            if (currentGroup.getMemberUsers().contains(user)) {
                userGroups.add(currentGroup);
                boolean inherit = !inheritOnly || currentGroup.isInheritingRoles();
                for (int i = stack.size() - 2; inherit && i >= 0; --i) {
                    Group group = stack.get(i);
                    userGroups.add(group);
                    inherit = !inheritOnly || group.isInheritingRoles();
                }
            }
            for (Group group : currentGroup.getMemberGroups()) {
                this.addGroups(user, userGroups, group, stack, inheritOnly);
            }
        }
    }

    public Set<Group> findGroups(User user) {
        return this.findGroups(user, true);
    }

    public Set<Group> findGroups(User user, boolean inheritOnly) {
        HashSet<Group> result = new HashSet<Group>();
        for (Group group : this.getRootGroups()) {
            ArrayList<Group> stack = new ArrayList<Group>();
            this.addGroups(user, result, group, stack, inheritOnly);
        }
        return result;
    }

    public Set<Role> findRoles(Group userGroup) {
        HashSet<Role> result = new HashSet<Role>();
        for (RoleMapping mapping : this.getRoleMappings()) {
            Object source = mapping.getSource();
            if (userGroup == null || !userGroup.equals(source)) continue;
            result.add(mapping.getTarget());
        }
        return result;
    }

    public Set<Role> findRoles(Set<Group> userGroups) {
        HashSet<Role> result = new HashSet<Role>();
        for (RoleMapping mapping : this.getRoleMappings()) {
            Object source = mapping.getSource();
            if (userGroups == null || !userGroups.contains(source)) continue;
            result.add(mapping.getTarget());
        }
        return result;
    }

    public Set<Role> findRoles(User user) {
        HashSet<Role> result = new HashSet<Role>();
        for (RoleMapping mapping : this.getRoleMappings()) {
            Object source = mapping.getSource();
            if (user == null || !user.equals(source)) continue;
            result.add(mapping.getTarget());
        }
        return result;
    }

    public User findUser(String userIdentifier) {
        User result = null;
        for (int i = 0; result == null && i < this.getUsers().size(); ++i) {
            User user = this.getUsers().get(i);
            if (!user.getIdentifier().equals(userIdentifier)) continue;
            result = user;
        }
        return result;
    }

    private List<RoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public List<Group> getRootGroups() {
        return this.rootGroups;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void map(Group group, Role role) {
        this.getRoleMappings().add(new RoleMapping(group, role));
    }

    public void map(User user, Role role) {
        this.getRoleMappings().add(new RoleMapping(user, role));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootGroups(List<Group> rootGroups) {
        List<Group> list = this.getRootGroups();
        synchronized (list) {
            if (rootGroups != this.getRootGroups()) {
                this.getRootGroups().clear();
                if (rootGroups != null) {
                    this.getRootGroups().addAll(rootGroups);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsers(List<User> users) {
        List<User> list = this.getUsers();
        synchronized (list) {
            if (users != this.getUsers()) {
                this.getUsers().clear();
                if (users != null) {
                    this.getUsers().addAll(users);
                }
            }
        }
    }

    public void unmap(Group group, Role role) {
        this.unmap((Object)group, role);
    }

    private void unmap(Object source, Role role) {
        for (int i = this.getRoleMappings().size(); i >= 0; --i) {
            RoleMapping mapping = this.getRoleMappings().get(i);
            if (!mapping.getSource().equals(source) || !mapping.getTarget().equals(role)) continue;
            this.getRoleMappings().remove(i);
        }
    }

    public void unmap(User user, Role role) {
        this.unmap((Object)user, role);
    }

    private class DefaultVerifier
    extends SecretVerifier {
        private DefaultVerifier() {
        }

        protected User createUser(String identifier) {
            User result = new User(identifier);
            User user = MemoryRealm.this.findUser(identifier);
            if (user != null) {
                result.setEmail(user.getEmail());
                result.setFirstName(user.getFirstName());
                result.setLastName(user.getLastName());
            }
            return result;
        }

        public boolean verify(String identifier, char[] secret) {
            char[] actualSecret = null;
            User user = MemoryRealm.this.findUser(identifier);
            if (user != null) {
                actualSecret = user.getSecret();
            }
            return DefaultVerifier.compare(secret, actualSecret);
        }
    }

    private class DefaultEnroler
    implements Enroler {
        private DefaultEnroler() {
        }

        public void enrole(ClientInfo clientInfo) {
            User user = MemoryRealm.this.findUser(clientInfo.getUser().getIdentifier());
            if (user != null) {
                Set<Group> userGroups = MemoryRealm.this.findGroups(user);
                Set<Role> userRoles = MemoryRealm.this.findRoles(user);
                for (Role role : userRoles) {
                    clientInfo.getRoles().add(role);
                }
                Set<Role> groupRoles = MemoryRealm.this.findRoles(userGroups);
                for (Role role : groupRoles) {
                    clientInfo.getRoles().add(role);
                }
            }
        }
    }
}

