/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.engine.Engine;
import org.restlet.engine.ServerHelper;
import org.restlet.engine.http.HttpRequest;
import org.restlet.engine.http.HttpResponse;
import org.restlet.engine.http.ServerCall;
import org.restlet.engine.http.adapter.ServerAdapter;

public class HttpServerHelper
extends ServerHelper {
    private volatile ServerAdapter adapter = null;

    public HttpServerHelper() {
        this(null);
    }

    public HttpServerHelper(Server server) {
        super(server);
    }

    public ServerAdapter getAdapter() {
        if (this.adapter == null) {
            try {
                String adapterClass = this.getHelpedParameters().getFirstValue("adapter", "org.restlet.engine.http.adapter.ServerAdapter");
                this.adapter = (ServerAdapter)Engine.loadClass(adapterClass).getConstructor(Context.class).newInstance(this.getContext());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (SecurityException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (InstantiationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (IllegalAccessException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (InvocationTargetException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server adapter", e);
            }
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServerCall httpCall) {
        try {
            HttpRequest request = this.getAdapter().toRequest(httpCall);
            HttpResponse response = new HttpResponse(httpCall, request);
            this.handle(request, response);
            this.getAdapter().commit(response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error while handling an HTTP server call: ", e.getMessage());
            this.getLogger().log(Level.INFO, "Error while handling an HTTP server call", e);
        }
        finally {
            Engine.clearThreadLocalVariables();
        }
    }

    public void setAdapter(ServerAdapter adapter) {
        this.adapter = adapter;
    }
}

