/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.component.ComponentHelper;
import org.restlet.engine.component.ComponentXmlParser;
import org.restlet.engine.component.InternalRouter;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.routing.Router;
import org.restlet.routing.VirtualHost;
import org.restlet.security.Realm;
import org.restlet.service.LogService;
import org.restlet.service.StatusService;
import org.restlet.util.ClientList;
import org.restlet.util.ServerList;
import org.restlet.util.ServiceList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component
extends Restlet {
    private final ClientList clients;
    private volatile VirtualHost defaultHost;
    private volatile RestletHelper<Component> helper;
    private final List<VirtualHost> hosts = new CopyOnWriteArrayList<VirtualHost>();
    private volatile Router internalRouter;
    private final List<Realm> realms;
    private final ServerList servers;
    private final ServiceList services;

    public static void main(String[] args) throws Exception {
        try {
            if (args == null || args.length != 1) {
                System.err.println("Can't launch the component. Requires the path to an XML configuration file.\n");
            } else {
                URI currentDirURI = new File(".").toURI();
                URI confURI = currentDirURI.resolve(args[0]);
                new Component(confURI.toString()).start();
            }
        }
        catch (Exception e) {
            System.err.println("Can't launch the component.\nAn unexpected exception occurred:");
            e.printStackTrace(System.err);
        }
    }

    public Component() {
        this.clients = new ClientList(null);
        this.servers = new ServerList(null, this);
        this.realms = new CopyOnWriteArrayList<Realm>();
        this.services = new ServiceList(this.getContext());
        if (Engine.getInstance() != null) {
            this.helper = new ComponentHelper(this);
            Context childContext = this.getContext().createChildContext();
            this.defaultHost = new VirtualHost(childContext);
            this.internalRouter = new InternalRouter(childContext);
            this.services.add(new LogService());
            this.getLogService().setContext(childContext);
            this.services.add(new StatusService());
            this.getStatusService().setContext(childContext);
            this.clients.setContext(childContext);
            this.servers.setContext(childContext);
        }
    }

    public Component(Reference xmlConfigRef) {
        this();
        Representation xmlConfigRepresentation = null;
        if (xmlConfigRef != null) {
            ClientResource cr = new ClientResource(xmlConfigRef);
            xmlConfigRepresentation = cr.get();
            if (xmlConfigRepresentation != null) {
                new ComponentXmlParser(this, xmlConfigRepresentation).parse();
            } else {
                this.getLogger().log(Level.WARNING, "Unable to get the Component XML configuration located at this URI: " + xmlConfigRef);
            }
        }
    }

    public Component(Representation xmlConfigRepresentation) {
        this();
        if (xmlConfigRepresentation != null) {
            new ComponentXmlParser(this, xmlConfigRepresentation).parse();
        } else {
            this.getLogger().log(Level.WARNING, "Unable to parse the Component XML configuration.");
        }
    }

    public Component(String xmlConfigurationRef) {
        this(xmlConfigurationRef == null ? null : new Reference(xmlConfigurationRef));
    }

    public ClientList getClients() {
        return this.clients;
    }

    public VirtualHost getDefaultHost() {
        return this.defaultHost;
    }

    private RestletHelper<Component> getHelper() {
        return this.helper;
    }

    public List<VirtualHost> getHosts() {
        return this.hosts;
    }

    public Router getInternalRouter() {
        return this.internalRouter;
    }

    public LogService getLogService() {
        return this.getServices().get(LogService.class);
    }

    public Realm getRealm(String name) {
        if (name != null) {
            for (Realm realm : this.getRealms()) {
                if (!name.equals(realm.getName())) continue;
                return realm;
            }
        }
        return null;
    }

    public List<Realm> getRealms() {
        return this.realms;
    }

    public ServerList getServers() {
        return this.servers;
    }

    public ServiceList getServices() {
        return this.services;
    }

    public StatusService getStatusService() {
        return this.getServices().get(StatusService.class);
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClients(ClientList clients) {
        ClientList clientList = this.getClients();
        synchronized (clientList) {
            if (clients != this.getClients()) {
                this.getClients().clear();
                if (clients != null) {
                    this.getClients().addAll(clients);
                }
            }
        }
    }

    public void setDefaultHost(VirtualHost defaultHost) {
        this.defaultHost = defaultHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHosts(List<VirtualHost> hosts) {
        List<VirtualHost> list = this.getHosts();
        synchronized (list) {
            if (hosts != this.getHosts()) {
                this.getHosts().clear();
                if (hosts != null) {
                    this.getHosts().addAll(hosts);
                }
            }
        }
    }

    public void setInternalRouter(Router internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setLogService(LogService logService) {
        this.getServices().set(logService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealms(List<Realm> realms) {
        List<Realm> list = this.getRealms();
        synchronized (list) {
            if (realms != this.getRealms()) {
                this.getRealms().clear();
                if (realms != null) {
                    this.getRealms().addAll(realms);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServers(ServerList servers) {
        ServerList serverList = this.getServers();
        synchronized (serverList) {
            if (servers != this.getServers()) {
                this.getServers().clear();
                if (servers != null) {
                    this.getServers().addAll(servers);
                }
            }
        }
    }

    public void setStatusService(StatusService statusService) {
        this.getServices().set(statusService);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            this.startClients();
            this.startServers();
            this.startRouters();
            this.startServices();
            this.startRealms();
            this.startHelper();
            super.start();
        }
    }

    protected synchronized void startClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.start();
            }
        }
    }

    protected synchronized void startHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    protected synchronized void startRealms() throws Exception {
        if (this.realms != null) {
            for (Realm realm : this.realms) {
                realm.start();
            }
        }
    }

    protected synchronized void startRouters() throws Exception {
        if (this.internalRouter != null) {
            this.internalRouter.start();
        }
        if (this.defaultHost != null) {
            this.defaultHost.start();
        }
        for (VirtualHost host : this.getHosts()) {
            host.start();
        }
    }

    protected synchronized void startServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.start();
            }
        }
    }

    protected synchronized void startServices() throws Exception {
        this.getServices().start();
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        this.stopHelper();
        this.stopRealms();
        this.stopServices();
        this.stopRouters();
        this.stopServers();
        this.stopClients();
    }

    protected synchronized void stopClients() throws Exception {
        if (this.clients != null) {
            for (Client client : this.clients) {
                client.stop();
            }
        }
    }

    protected synchronized void stopHelper() throws Exception {
        if (this.getHelper() != null) {
            this.getHelper().stop();
        }
    }

    protected synchronized void stopRealms() throws Exception {
        if (this.realms != null) {
            for (Realm realm : this.realms) {
                realm.stop();
            }
        }
    }

    protected synchronized void stopRouters() throws Exception {
        for (VirtualHost host : this.getHosts()) {
            host.stop();
        }
        if (this.defaultHost != null) {
            this.defaultHost.stop();
        }
        if (this.internalRouter != null) {
            this.internalRouter.stop();
        }
    }

    protected synchronized void stopServers() throws Exception {
        if (this.servers != null) {
            for (Server server : this.servers) {
                server.stop();
            }
        }
    }

    protected synchronized void stopServices() throws Exception {
        this.getServices().stop();
    }

    public synchronized void updateHosts() throws Exception {
        this.getHelper().update();
    }
}

