/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JRXmlDocumentProducer {
    private File file;
    private InputStream inputStream;
    private String uri;
    private DocumentBuilderFactory documentBuilderFactory;

    public JRXmlDocumentProducer() {
    }

    public JRXmlDocumentProducer(File file) {
        this.file = file;
    }

    public JRXmlDocumentProducer(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public JRXmlDocumentProducer(String uri) {
        this.uri = uri;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Document getDocument() throws JRException {
        try {
            if (this.file != null) {
                return this.getDocumentBuilder().parse(this.file);
            }
            if (this.inputStream != null) {
                return this.getDocumentBuilder().parse(this.inputStream);
            }
            if (this.uri != null) {
                return this.getDocumentBuilder().parse(this.uri);
            }
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        return null;
    }

    public Document getDocument(Node sourceNode) throws JRException {
        Document doc = this.getDocumentBuilder().newDocument();
        Node source = sourceNode.getNodeType() == 9 ? ((Document)sourceNode).getDocumentElement() : sourceNode;
        Node node = doc.importNode(source, true);
        doc.appendChild(node);
        return doc;
    }

    protected DocumentBuilder getDocumentBuilder() throws JRException {
        try {
            if (this.documentBuilderFactory != null) {
                return this.documentBuilderFactory.newDocumentBuilder();
            }
            return JRXmlUtils.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException("Failed to create a document builder", e);
        }
    }
}

