/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.IndexColumnValueIterator;

public class LongArrayValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private long[] values;
    private long linearFactor;
    private long linearOffset;

    public LongArrayValues(long[] values, long linearFactor, long linearOffset) {
        this.values = values;
        this.linearFactor = linearFactor;
        this.linearOffset = linearOffset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.linearFactor);
        out.writeLong(this.linearOffset);
        out.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            out.writeLong(this.values[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.linearFactor = in.readLong();
        this.linearOffset = in.readLong();
        int size = in.readInt();
        this.values = new long[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readLong();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    extends IndexColumnValueIterator {
        public ValuesIterator() {
            super(LongArrayValues.this.values.length);
        }

        @Override
        public Object get() {
            return LongArrayValues.this.values[this.currentIndex] * LongArrayValues.this.linearFactor + LongArrayValues.this.linearOffset;
        }
    }
}

