/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.Item;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.ItemProperty;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapCompiler
implements ComponentCompiler {
    private static final Map<String, String> addressMap = new HashMap<String, String>();

    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        List<ItemData> pathDataList;
        List<ItemData> pathStyleList;
        MapComponent map = (MapComponent)component;
        collector.addExpression(map.getLatitudeExpression());
        collector.addExpression(map.getLongitudeExpression());
        collector.addExpression(map.getAddressExpression());
        collector.addExpression(map.getZoomExpression());
        collector.addExpression(map.getLanguageExpression());
        List<ItemData> markerDataList = map.getMarkerDataList();
        if (markerDataList != null && markerDataList.size() > 0) {
            for (ItemData markerData : markerDataList) {
                MapCompiler.collectExpressions(markerData, collector);
            }
        }
        if ((pathStyleList = map.getPathStyleList()) != null && pathStyleList.size() > 0) {
            for (ItemData pathStyle : pathStyleList) {
                MapCompiler.collectExpressions(pathStyle, collector);
            }
        }
        if ((pathDataList = map.getPathDataList()) != null && pathDataList.size() > 0) {
            for (ItemData pathData : pathDataList) {
                MapCompiler.collectExpressions(pathData, collector);
            }
        }
    }

    public static void collectExpressions(ItemData data, JRExpressionCollector collector) {
        if (data != null) {
            List<Item> items;
            JRDatasetRun datasetRun;
            JRExpressionCollector datasetCollector = collector;
            JRElementDataset dataset = data.getDataset();
            JRDatasetRun jRDatasetRun = datasetRun = dataset == null ? null : dataset.getDatasetRun();
            if (datasetRun != null) {
                collector.collect(datasetRun);
                datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
            }
            if ((items = data.getItems()) != null && !items.isEmpty()) {
                for (Item item : items) {
                    List<ItemProperty> itemProperties = item.getProperties();
                    if (itemProperties == null) continue;
                    for (ItemProperty property : itemProperties) {
                        datasetCollector.addExpression(property.getValueExpression());
                    }
                }
            }
        }
    }

    public static void collectExpressions(MarkerDataset dataset, JRExpressionCollector collector) {
        if (dataset != null) {
            List<Marker> markers;
            JRExpressionCollector datasetCollector = collector;
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                collector.collect(datasetRun);
                datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
            }
            if ((markers = dataset.getMarkers()) != null && !markers.isEmpty()) {
                for (Marker marker : markers) {
                    List<MarkerProperty> markerProperties = marker.getProperties();
                    if (markerProperties == null) continue;
                    for (MarkerProperty property : markerProperties) {
                        datasetCollector.addExpression(property.getValueExpression());
                    }
                }
            }
        }
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        MapComponent map = (MapComponent)component;
        return new StandardMapComponent(map, baseFactory);
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        List<ItemData> pathDataList;
        List<ItemData> pathStyleList;
        MapComponent map = (MapComponent)component;
        EvaluationTimeEnum evaluationTime = map.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for maps", (Object)map);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = map.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for map", (Object)map);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Map evalution group \"" + evaluationGroup + " not found", (Object)map);
            }
        }
        if ((map.getLatitudeExpression() == null || map.getLongitudeExpression() == null) && map.getAddressExpression() == null) {
            verifier.addBrokenRule("Missing the latitude and/or the longitude expression for the map center. Try to configure them properly, or configure the equivalent addressExpression for this map.", (Object)map);
        }
        String[] reqNames = new String[]{"latitude", "longitude"};
        List<ItemData> markerDataList = map.getMarkerDataList();
        if (markerDataList != null && markerDataList.size() > 0) {
            for (ItemData markerData : markerDataList) {
                this.verifyItemData(verifier, markerData, "markerData", reqNames, addressMap);
            }
        }
        if ((pathStyleList = map.getPathStyleList()) != null && pathStyleList.size() > 0) {
            for (ItemData pathStyle : pathStyleList) {
                this.verifyItemData(verifier, pathStyle, "pathStyle", new String[]{"name"}, null);
            }
        }
        if ((pathDataList = map.getPathDataList()) != null && pathDataList.size() > 0) {
            for (ItemData pathData : pathDataList) {
                this.verifyItemData(verifier, pathData, "pathData", reqNames, addressMap);
            }
        }
    }

    protected void verifyMarkerData(JRVerifier verifier, ItemData itemData) {
        this.verifyItemData(verifier, itemData, "markerData", new String[]{"latitude", "longitude"}, addressMap);
    }

    protected void verifyMarker(JRVerifier verifier, Item item) {
        this.verifyItem(verifier, item, "markerData", new String[]{"latitude", "longitude"}, addressMap);
    }

    protected void verifyItemData(JRVerifier verifier, ItemData itemData, String itemName, String[] requiredNames, Map<String, String> alternativeNamesMap) {
        List<Item> items;
        if (itemData.getDataset() != null) {
            verifier.verifyElementDataset(itemData.getDataset());
        }
        if ((items = itemData.getItems()) != null) {
            for (Item item : items) {
                this.verifyItem(verifier, item, itemName, requiredNames, alternativeNamesMap);
            }
        }
    }

    protected void verifyItem(JRVerifier verifier, Item item, String itemName, String[] requiredNames, Map<String, String> alternativeNamesMap) {
        List<ItemProperty> itemProperties;
        if (requiredNames != null && requiredNames.length > 0 && (itemProperties = item.getProperties()) != null && !itemProperties.isEmpty()) {
            for (String reqName : requiredNames) {
                boolean hasProperty = false;
                for (ItemProperty itemProperty : itemProperties) {
                    if (!itemProperty.getName().equals(reqName) && (alternativeNamesMap == null || !itemProperty.getName().equals(alternativeNamesMap.get(reqName)))) continue;
                    hasProperty = true;
                    break;
                }
                if (hasProperty) continue;
                verifier.addBrokenRule("No '" + reqName + "' property set for the " + itemName + " item.", itemProperties);
            }
        }
    }

    static {
        addressMap.put("latitude", "address");
        addressMap.put("longitude", "address");
    }
}

