/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.html;

import net.sf.jasperreports.components.html.HtmlComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import net.sf.jasperreports.engine.xml.XmlConstantPropertyRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class HtmlComponentDigester
implements XmlDigesterConfigurer {
    @Override
    public void configureDigester(Digester digester) {
        this.setHtmlComponentRules(digester);
    }

    protected void setHtmlComponentRules(Digester digester) {
        String htmlComponentPattern = "*/componentElement/html";
        digester.addObjectCreate(htmlComponentPattern, HtmlComponent.class.getName());
        digester.addSetProperties(htmlComponentPattern, new String[]{"scaleType", "horizontalAlign", "verticalAlign", "evaluationTime"}, new String[0]);
        digester.addRule(htmlComponentPattern, (Rule)new XmlConstantPropertyRule("scaleType", ScaleImageEnum.values()));
        digester.addRule(htmlComponentPattern, (Rule)new XmlConstantPropertyRule("horizontalAlign", HorizontalAlignEnum.values()));
        digester.addRule(htmlComponentPattern, (Rule)new XmlConstantPropertyRule("verticalAlign", VerticalAlignEnum.values()));
        digester.addRule(htmlComponentPattern, (Rule)new XmlConstantPropertyRule("evaluationTime", EvaluationTimeEnum.values()));
        String htmlContentPattern = htmlComponentPattern + "/htmlContentExpression";
        digester.addFactoryCreate(htmlContentPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(htmlContentPattern, "setText", 0);
        digester.addSetNext(htmlContentPattern, "setHtmlContentExpression", JRExpression.class.getName());
    }
}

