/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.base.VirtualizablePageElements;
import net.sf.jasperreports.engine.fill.ElementEvaluationAction;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.PageKey;
import net.sf.jasperreports.engine.fill.VirtualizationListener;
import net.sf.jasperreports.engine.fill.VirtualizedPageEvaluationAction;
import net.sf.jasperreports.engine.util.LinkedMap;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ElementEvaluationVirtualizationListener
implements VirtualizationListener<VirtualElementsData> {
    private static final Log log = LogFactory.getLog(ElementEvaluationAction.class);
    private final JRBaseFiller mainFiller;

    public ElementEvaluationVirtualizationListener(JRBaseFiller filler) {
        this.mainFiller = filler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExternalization(JRVirtualizable<VirtualElementsData> object) {
        JRVirtualizationContext virtualizationContext = object.getContext();
        virtualizationContext.lock();
        try {
            this.setElementEvaluationsToPage(this.mainFiller, object);
        }
        finally {
            virtualizationContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setElementEvaluationsToPage(final JRBaseFiller filler, final JRVirtualizable<VirtualElementsData> object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("filler " + filler.fillerId + " setting element evaluation for elements in " + object.getUID()));
        }
        JRVirtualPrintPage page = ((VirtualizablePageElements)((Object)object)).getPage();
        PageKey pageKey = new PageKey(page);
        VirtualElementsData virtualData = object.getVirtualData();
        for (Map.Entry<JREvaluationTime, LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>>> boundMapEntry : filler.boundElements.entrySet()) {
            LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>> map;
            final JREvaluationTime evaluationTime = boundMapEntry.getKey();
            LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map = boundMapEntry.getValue();
            synchronized (linkedHashMap) {
                final LinkedMap<Object, EvaluationBoundAction> actionsMap = map.get(pageKey);
                if (actionsMap != null && !actionsMap.isEmpty()) {
                    final LinkedHashMap<JRPrintElement, Integer> elementEvaluations = new LinkedHashMap<JRPrintElement, Integer>();
                    UniformPrintElementVisitor<Void> visitor = new UniformPrintElementVisitor<Void>(true){

                        @Override
                        protected void visitElement(JRPrintElement element, Void arg) {
                            ElementEvaluationAction action = (ElementEvaluationAction)actionsMap.remove(element);
                            if (action != null) {
                                elementEvaluations.put(element, action.element.printElementOriginator.getSourceElementId());
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("filler " + filler.fillerId + " saving evaluation " + evaluationTime + " of element " + element + " on object " + object));
                                }
                            }
                        }
                    };
                    for (JRPrintElement element : virtualData.getElements()) {
                        element.accept(visitor, null);
                    }
                    if (!elementEvaluations.isEmpty()) {
                        virtualData.setElementEvaluations(filler.fillerId, evaluationTime, elementEvaluations);
                        actionsMap.add(null, new VirtualizedPageEvaluationAction(object));
                    }
                }
            }
        }
        if (filler.subfillers != null) {
            for (JRBaseFiller subfiller : filler.subfillers.values()) {
                this.setElementEvaluationsToPage(subfiller, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterInternalization(JRVirtualizable<VirtualElementsData> object) {
        JRVirtualizationContext virtualizationContext = object.getContext();
        virtualizationContext.lock();
        try {
            this.getElementEvaluationsFromPage(this.mainFiller, object);
        }
        finally {
            virtualizationContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getElementEvaluationsFromPage(JRBaseFiller filler, JRVirtualizable<VirtualElementsData> object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("filler " + filler.fillerId + " recreating element evaluation for elements in " + object.getUID()));
        }
        JRVirtualPrintPage page = ((VirtualizablePageElements)((Object)object)).getPage();
        PageKey pageKey = new PageKey(page);
        VirtualElementsData elementsData = object.getVirtualData();
        for (Map.Entry<JREvaluationTime, LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>>> boundMapEntry : filler.boundElements.entrySet()) {
            LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>> map;
            JREvaluationTime evaluationTime = boundMapEntry.getKey();
            LinkedHashMap<PageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map = boundMapEntry.getValue();
            synchronized (linkedHashMap) {
                LinkedMap<Object, EvaluationBoundAction> actionsMap = map.get(pageKey);
                Map<JRPrintElement, Integer> elementEvaluations = elementsData.getElementEvaluations(filler.fillerId, evaluationTime);
                if (elementEvaluations != null) {
                    for (Map.Entry<JRPrintElement, Integer> entry : elementEvaluations.entrySet()) {
                        JRPrintElement element = entry.getKey();
                        int fillElementId = entry.getValue();
                        JRFillElement fillElement = filler.fillElements.get(fillElementId);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("filler " + filler.fillerId + " got evaluation " + evaluationTime + " on " + element + " from object " + object + ", using " + fillElement));
                        }
                        if (fillElement == null) {
                            throw new JRRuntimeException("Fill element with id " + fillElementId + " not found");
                        }
                        actionsMap.addFirst(element, new ElementEvaluationAction(fillElement, element));
                    }
                }
            }
        }
        if (filler.subfillers != null) {
            for (JRBaseFiller subfiller : filler.subfillers.values()) {
                this.getElementEvaluationsFromPage(subfiller, object);
            }
        }
    }
}

