/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.Bookmark;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.PrintBookmark;
import net.sf.jasperreports.engine.PrintElementId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BookmarkStack {
    private static final Log log = LogFactory.getLog(BookmarkStack.class);
    LinkedList<Bookmark> stack = new LinkedList();
    boolean isCollapseMissingBookmarkLevels;
    Map<PrintElementId, Bookmark> updateableBookmarks;

    public BookmarkStack(boolean isCollapseMissingBookmarkLevels) {
        this.isCollapseMissingBookmarkLevels = isCollapseMissingBookmarkLevels;
        this.push(new Bookmark(null, null, 0, null));
        this.updateableBookmarks = new HashMap<PrintElementId, Bookmark>();
    }

    public void push(Bookmark bookmark) {
        this.stack.add(bookmark);
    }

    public Bookmark pop() {
        return this.stack.removeLast();
    }

    public Bookmark peek() {
        return this.stack.getLast();
    }

    protected Bookmark addBookmark(int level, String label, int pageIndex, String elementAddress) {
        Bookmark parent = this.peek();
        while (parent.getLevel() >= level) {
            this.pop();
            parent = this.peek();
        }
        if (!this.isCollapseMissingBookmarkLevels) {
            PrintBookmark parentPrintBookmark = parent.getPrintBookmark();
            for (int i = parent.getLevel() + 1; i < level; ++i) {
                Bookmark emptyBookmark = new Bookmark(parent, "", parentPrintBookmark.getPageIndex(), parentPrintBookmark.getElementAddress());
                this.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        Bookmark bookmark = new Bookmark(parent, label, pageIndex, elementAddress);
        this.push(bookmark);
        return bookmark;
    }

    protected void addBookmarks(List<JRPrintElement> elements, int pageIndex, String elementAddress) {
        if (elements != null) {
            elementAddress = elementAddress == null ? "" : elementAddress;
            int i = 0;
            for (JRPrintElement element : elements) {
                JRPrintAnchor anchor;
                int level;
                if (element instanceof JRPrintFrame) {
                    this.addBookmarks(((JRPrintFrame)element).getElements(), pageIndex, elementAddress + (elementAddress.length() == 0 ? "" : "_") + i + "_");
                } else if (element instanceof JRPrintAnchor && (level = (anchor = (JRPrintAnchor)((Object)element)).getBookmarkLevel()) != 0) {
                    String anchorName = anchor.getAnchorName();
                    Bookmark bookmark = this.addBookmark(level, anchorName, pageIndex, elementAddress + i);
                    if (anchorName == null) {
                        PrintElementId elementId = PrintElementId.forElement(element);
                        this.updateableBookmarks.put(elementId, bookmark);
                    }
                }
                ++i;
            }
        }
    }

    public void updateBookmark(JRPrintElement element) {
        JRPrintAnchor anchor;
        int level;
        if (element instanceof JRPrintAnchor && (level = (anchor = (JRPrintAnchor)((Object)element)).getBookmarkLevel()) != 0) {
            PrintElementId elementId = PrintElementId.forElement(element);
            Bookmark bookmark = this.updateableBookmarks.get(elementId);
            if (bookmark == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cound not find bookmark for " + elementId + " to update"));
                }
            } else {
                String anchorName = anchor.getAnchorName();
                bookmark.updateLabel(anchorName);
            }
        }
    }

    protected List<PrintBookmark> getRootBookmarks() {
        return this.stack.getFirst().getPrintBookmark().getBookmarks();
    }
}

