/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components;

import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.components.AbstractComponentXmlWriter;
import net.sf.jasperreports.components.ComponentsExtensionsRegistryFactory;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeXmlWriter;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.components.map.Item;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.ItemProperty;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.components.sort.SortComponentXmlWriter;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.SpiderChartXmlWriter;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.WhenNoDataTypeTableEnum;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class ComponentsXmlWriter
extends AbstractComponentXmlWriter {
    public ComponentsXmlWriter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        if (component instanceof ListComponent) {
            this.writeList(componentElement, reportWriter);
        } else if (component instanceof TableComponent) {
            this.writeTable(componentElement, reportWriter);
        } else if (component instanceof BarbecueComponent) {
            this.writeBarbecue(componentElement, reportWriter);
        } else if (component instanceof BarcodeComponent) {
            BarcodeXmlWriter barcodeWriter = new BarcodeXmlWriter(reportWriter, componentElement, ComponentsXmlWriter.getVersion(this.jasperReportsContext, componentElement, reportWriter), this.versionComparator);
            barcodeWriter.writeBarcode();
        } else if (component instanceof SpiderChartComponent) {
            SpiderChartXmlWriter spiderChartWriter = new SpiderChartXmlWriter(this.jasperReportsContext, ComponentsXmlWriter.getVersion(this.jasperReportsContext, componentElement, reportWriter), this.versionComparator);
            spiderChartWriter.writeToXml(componentElement, reportWriter);
        } else if (component instanceof SortComponent) {
            SortComponentXmlWriter sortWriter = new SortComponentXmlWriter(this.jasperReportsContext);
            sortWriter.writeToXml(componentElement, reportWriter);
        } else if (component instanceof MapComponent) {
            this.writeMap(componentElement, reportWriter);
        }
    }

    protected void writeList(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        ListComponent list = (ListComponent)componentElement.getComponent();
        ComponentKey componentKey = componentElement.getComponentKey();
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("list", namespace);
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "3.6.1")) {
            writer.addAttribute("printOrder", list.getPrintOrderValue());
        }
        writer.addAttribute("ignoreWidth", list.getIgnoreWidth());
        reportWriter.writeDatasetRun(list.getDatasetRun());
        ListContents contents = list.getContents();
        writer.startElement("listContents");
        writer.addAttribute("height", contents.getHeight());
        writer.addAttribute("width", contents.getWidth());
        reportWriter.writeChildElements(contents);
        writer.closeElement();
        writer.closeElement();
    }

    protected void writeBarbecue(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        BarbecueComponent barcode = (BarbecueComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        ComponentKey componentKey = componentElement.getComponentKey();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("barbecue", namespace);
        writer.addAttribute("type", barcode.getType());
        writer.addAttribute("drawText", barcode.isDrawText());
        writer.addAttribute("checksumRequired", barcode.isChecksumRequired());
        writer.addAttribute("barWidth", barcode.getBarWidth());
        writer.addAttribute("barHeight", barcode.getBarHeight());
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.0.0")) {
            writer.addAttribute("rotation", barcode.getOwnRotation());
        }
        if (barcode.getEvaluationTimeValue() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", barcode.getEvaluationTimeValue());
        }
        writer.addAttribute("evaluationGroup", barcode.getEvaluationGroup());
        this.writeExpression("codeExpression", barcode.getCodeExpression(), false, componentElement, reportWriter);
        this.writeExpression("applicationIdentifierExpression", barcode.getApplicationIdentifierExpression(), false, componentElement, reportWriter);
        writer.closeElement();
    }

    protected void writeMap(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        MapComponent map = (MapComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        ComponentKey componentKey = componentElement.getComponentKey();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("map", namespace);
        if (map.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", map.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", map.getEvaluationGroup());
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.8.0")) {
            writer.addAttribute("mapType", map.getMapType(), MapTypeEnum.ROADMAP);
            writer.addAttribute("mapScale", map.getMapScale(), MapScaleEnum.ONE);
            writer.addAttribute("imageType", map.getImageType(), MapImageTypeEnum.PNG);
            if (this.isNewerVersionOrEqual(componentElement, reportWriter, "5.5.0")) {
                writer.addAttribute("onErrorType", map.getOnErrorType(), OnErrorTypeEnum.ERROR);
            }
        }
        writer.writeExpression("latitudeExpression", map.getLatitudeExpression());
        writer.writeExpression("longitudeExpression", map.getLongitudeExpression());
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "5.5.2")) {
            writer.writeExpression("addressExpression", map.getAddressExpression());
        }
        writer.writeExpression("zoomExpression", map.getZoomExpression());
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.8.0")) {
            writer.writeExpression("languageExpression", map.getLanguageExpression());
        }
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "5.5.2")) {
            List<ItemData> markerDataList = map.getMarkerDataList();
            if (markerDataList != null && markerDataList.size() > 0) {
                for (ItemData markerData : markerDataList) {
                    this.writeItemData("markerData", markerData, writer, reportWriter, namespace, componentElement);
                }
            }
        } else if (this.isNewerVersionOrEqual(componentElement, reportWriter, "5.0.4")) {
            ItemData itemData = map.getMarkerData();
            this.writeItemData("markerData", itemData, writer, reportWriter, namespace, componentElement);
        } else if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.8.0")) {
            MarkerDataset dataset = map.getMarkerDataset();
            this.writeMarkerDataset(dataset, writer, reportWriter, namespace, componentElement);
        }
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "5.5.0")) {
            List<ItemData> pathDataList;
            List<ItemData> pathStyleList = map.getPathStyleList();
            if (pathStyleList != null && pathStyleList.size() > 0) {
                for (ItemData pathStyle : pathStyleList) {
                    this.writeItemData("pathStyle", pathStyle, writer, reportWriter, namespace, componentElement);
                }
            }
            if ((pathDataList = map.getPathDataList()) != null && pathDataList.size() > 0) {
                for (ItemData pathData : pathDataList) {
                    this.writeItemData("pathData", pathData, writer, reportWriter, namespace, componentElement);
                }
            }
        }
        writer.closeElement();
    }

    private void writeItemData(String name, ItemData itemData, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        if (itemData != null) {
            this.writeItemDataContent(name, itemData, writer, reportWriter, namespace, componentElement);
            writer.closeElement();
        }
    }

    private void writeItemDataContent(String name, ItemData itemData, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        List<Item> itemList;
        writer.startElement(name, namespace);
        JRElementDataset dataset = itemData.getDataset();
        if (dataset != null) {
            reportWriter.writeElementDataset(dataset, false);
        }
        if ((itemList = itemData.getItems()) != null && !itemList.isEmpty()) {
            for (Item item : itemList) {
                if (item.getProperties() == null || item.getProperties().isEmpty()) continue;
                this.writeItem(item, writer, reportWriter, namespace, componentElement);
            }
        }
    }

    private void writeItem(Item item, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        writer.startElement("item", namespace);
        List<ItemProperty> itemProperties = item.getProperties();
        for (ItemProperty property : itemProperties) {
            this.writeItemProperty(property, writer, reportWriter, namespace, componentElement);
        }
        writer.closeElement();
    }

    private void writeItemProperty(ItemProperty itemProperty, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        writer.startElement("itemProperty", namespace);
        writer.addAttribute("name", itemProperty.getName());
        if (itemProperty.getValue() != null) {
            writer.addAttribute("value", itemProperty.getValue());
        }
        this.writeExpression("valueExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, itemProperty.getValueExpression(), false, componentElement, reportWriter);
        writer.closeElement();
    }

    private void writeMarkerDataset(MarkerDataset dataset, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        if (dataset != null) {
            List<Marker> markerList;
            writer.startElement("markerDataset", namespace);
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                reportWriter.writeDatasetRun(datasetRun);
            }
            if ((markerList = dataset.getMarkers()) != null && !markerList.isEmpty()) {
                for (Marker marker : markerList) {
                    if (marker.getProperties() == null || marker.getProperties().isEmpty()) continue;
                    this.writeMarker(marker, writer, reportWriter, namespace, componentElement);
                }
            }
            writer.closeElement();
        }
    }

    private void writeMarker(Marker marker, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        writer.startElement("marker", namespace);
        List<MarkerProperty> markerProperties = marker.getProperties();
        for (MarkerProperty property : markerProperties) {
            this.writeMarkerProperty(property, writer, reportWriter, namespace, componentElement);
        }
        writer.closeElement();
    }

    private void writeMarkerProperty(MarkerProperty markerProperty, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        writer.startElement("markerProperty", namespace);
        writer.addAttribute("name", markerProperty.getName());
        if (markerProperty.getValue() != null) {
            writer.addAttribute("value", markerProperty.getValue());
        }
        this.writeExpression("valueExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, markerProperty.getValueExpression(), false, componentElement, reportWriter);
        writer.closeElement();
    }

    protected void writeTable(final JRComponentElement componentElement, final JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        TableComponent table = (TableComponent)component;
        final JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        ComponentKey componentKey = componentElement.getComponentKey();
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        writer.startElement("table", namespace);
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.1")) {
            writer.addAttribute("whenNoDataType", table.getWhenNoDataType(), WhenNoDataTypeTableEnum.BLANK);
        }
        reportWriter.writeDatasetRun(table.getDatasetRun());
        ColumnVisitor<Void> columnWriter = new ColumnVisitor<Void>(){

            @Override
            public Void visitColumn(Column column) {
                try {
                    writer.startElement("column");
                    writer.addAttribute("width", column.getWidth());
                    if (ComponentsXmlWriter.this.isNewerVersionOrEqual(componentElement, reportWriter, "4.6.0")) {
                        writer.addEncodedAttribute("uuid", column.getUUID().toString());
                        reportWriter.writeProperties(column);
                        reportWriter.writePropertyExpressions(column.getPropertyExpressions());
                    }
                    ComponentsXmlWriter.this.writeExpression("printWhenExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, column.getPrintWhenExpression(), false, componentElement, reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, column.getTableHeader(), "tableHeader", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, column.getTableFooter(), "tableFooter", reportWriter);
                    ComponentsXmlWriter.this.writeGroupCells(componentElement, column.getGroupHeaders(), "groupHeader", reportWriter);
                    ComponentsXmlWriter.this.writeGroupCells(componentElement, column.getGroupFooters(), "groupFooter", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, column.getColumnHeader(), "columnHeader", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, column.getColumnFooter(), "columnFooter", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, column.getDetailCell(), "detailCell", reportWriter);
                    writer.closeElement();
                }
                catch (IOException e) {
                    throw new JRRuntimeException(e);
                }
                return null;
            }

            @Override
            public Void visitColumnGroup(ColumnGroup columnGroup) {
                try {
                    writer.startElement("columnGroup");
                    writer.addAttribute("width", columnGroup.getWidth());
                    if (ComponentsXmlWriter.this.isNewerVersionOrEqual(componentElement, reportWriter, "4.6.0")) {
                        writer.addEncodedAttribute("uuid", columnGroup.getUUID().toString());
                        reportWriter.writeProperties(columnGroup);
                        reportWriter.writePropertyExpressions(columnGroup.getPropertyExpressions());
                    }
                    ComponentsXmlWriter.this.writeExpression("printWhenExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, columnGroup.getPrintWhenExpression(), false, componentElement, reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, columnGroup.getTableHeader(), "tableHeader", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, columnGroup.getTableFooter(), "tableFooter", reportWriter);
                    ComponentsXmlWriter.this.writeGroupCells(componentElement, columnGroup.getGroupHeaders(), "groupHeader", reportWriter);
                    ComponentsXmlWriter.this.writeGroupCells(componentElement, columnGroup.getGroupFooters(), "groupFooter", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, columnGroup.getColumnHeader(), "columnHeader", reportWriter);
                    ComponentsXmlWriter.this.writeTableCell(componentElement, columnGroup.getColumnFooter(), "columnFooter", reportWriter);
                    for (BaseColumn column : columnGroup.getColumns()) {
                        column.visitColumn(this);
                    }
                    writer.closeElement();
                }
                catch (IOException e) {
                    throw new JRRuntimeException(e);
                }
                return null;
            }
        };
        for (BaseColumn column : table.getColumns()) {
            column.visitColumn(columnWriter);
        }
        writer.closeElement();
    }

    protected void writeGroupCells(JRComponentElement componentElement, List<GroupCell> cells, String name, JRXmlWriter reportWriter) throws IOException {
        if (cells != null) {
            JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
            for (GroupCell groupCell : cells) {
                writer.startElement(name);
                writer.addAttribute("groupName", groupCell.getGroupName());
                this.writeTableCell(componentElement, groupCell.getCell(), "cell", reportWriter);
                writer.closeElement();
            }
        }
    }

    protected void writeTableCell(JRComponentElement componentElement, Cell cell, String name, JRXmlWriter reportWriter) throws IOException {
        if (cell != null) {
            JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
            writer.startElement(name);
            reportWriter.writeStyleReferenceAttr(cell);
            writer.addAttribute("height", cell.getHeight());
            writer.addAttribute("rowSpan", cell.getRowSpan());
            if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.8.0")) {
                reportWriter.writeProperties(cell);
            }
            reportWriter.writeBox(cell.getLineBox(), JRXmlWriter.JASPERREPORTS_NAMESPACE);
            reportWriter.writeChildElements(cell);
            writer.closeElement();
        }
    }

    @Override
    public boolean isToWrite(JRComponentElement componentElement, JRXmlWriter reportWriter) {
        ComponentKey componentKey = componentElement.getComponentKey();
        if ("http://jasperreports.sourceforge.net/jasperreports/components".equals(componentKey.getNamespace())) {
            if ("sort".equals(componentKey.getName()) || "map".equals(componentKey.getName())) {
                return this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.1");
            }
            if ("spiderChart".equals(componentKey.getName())) {
                return this.isNewerVersionOrEqual(componentElement, reportWriter, "3.7.4");
            }
            if ("table".equals(componentKey.getName())) {
                return this.isNewerVersionOrEqual(componentElement, reportWriter, "3.7.2");
            }
            if ("list".equals(componentKey.getName())) {
                return this.isNewerVersionOrEqual(componentElement, reportWriter, "3.5.1");
            }
            if ("barbecue".equals(componentKey.getName()) || this.isBarcode4jName(componentKey.getName())) {
                return this.isNewerVersionOrEqual(componentElement, reportWriter, "3.5.2");
            }
        }
        return true;
    }

    protected boolean isBarcode4jName(String name) {
        for (String barcode4jName : ComponentsExtensionsRegistryFactory.BARCODE4J_COMPONENT_NAMES) {
            if (!barcode4jName.equals(name)) continue;
            return true;
        }
        return false;
    }
}

