/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;

public class PrimaryGridUnit
extends GridUnit {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$PrimaryGridUnit == null ? (class$org$apache$fop$layoutmgr$table$PrimaryGridUnit = PrimaryGridUnit.class$("org.apache.fop.layoutmgr.table.PrimaryGridUnit")) : class$org$apache$fop$layoutmgr$table$PrimaryGridUnit));
    private TableCellLayoutManager cellLM;
    private LinkedList elements;
    private int startRow;
    private List rows;
    private int contentLength = -1;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$PrimaryGridUnit;

    public PrimaryGridUnit(TableCell cell, TableColumn column, int startCol, int startRow) {
        super(cell, column, startCol, 0);
        this.startRow = startRow;
        log.trace((Object)("PrimaryGridUnit created, row " + startRow + " col " + startCol));
        if (cell != null) {
            this.cellLM = new TableCellLayoutManager(cell, this);
        }
    }

    public TableCellLayoutManager getCellLM() {
        return this.cellLM;
    }

    public boolean isPrimary() {
        return true;
    }

    public void setElements(LinkedList elements) {
        this.elements = elements;
    }

    public LinkedList getElements() {
        return this.elements;
    }

    public int getHalfMaxBeforeBorderWidth() {
        int value = 0;
        if (this.getRows() != null) {
            int before = 0;
            GridUnit[] row = (GridUnit[])this.getRows().get(0);
            for (int i = 0; i < row.length; ++i) {
                if (!row[i].hasBorders()) continue;
                before = Math.max(before, row[i].getBorders().getBorderBeforeWidth(false));
            }
            value += before / 2;
        } else if (this.hasBorders()) {
            value += this.getBorders().getBorderBeforeWidth(false) / 2;
        }
        return value;
    }

    public int getHalfMaxAfterBorderWidth() {
        int value = 0;
        if (this.getRows() != null) {
            int after = 0;
            GridUnit[] row = (GridUnit[])this.getRows().get(this.getRows().size() - 1);
            for (int i = 0; i < row.length; ++i) {
                if (!row[i].hasBorders()) continue;
                after = Math.max(after, row[i].getBorders().getBorderAfterWidth(false));
            }
            value += after / 2;
        } else if (this.hasBorders()) {
            value += this.getBorders().getBorderAfterWidth(false) / 2;
        }
        return value;
    }

    public int getHalfMaxBorderWidth() {
        return this.getHalfMaxBeforeBorderWidth() + this.getHalfMaxAfterBorderWidth();
    }

    public void setContentLength(int value) {
        this.contentLength = value;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public boolean hasBPD() {
        if (!this.getCell().getBlockProgressionDimension().getOptimum(null).isAuto()) {
            return true;
        }
        return this.getRow() != null && !this.getRow().getBlockProgressionDimension().getOptimum(null).isAuto();
    }

    public List getRows() {
        return this.rows;
    }

    public void addRow(GridUnit[] row) {
        if (this.rows == null) {
            this.rows = new ArrayList();
        }
        this.rows.add(row);
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int[] getStartEndBorderWidths() {
        int[] widths = new int[2];
        if (this.rows == null) {
            widths[0] = this.getBorders().getBorderStartWidth(false);
            widths[1] = this.getBorders().getBorderEndWidth(false);
        } else {
            for (int i = 0; i < this.rows.size(); ++i) {
                GridUnit[] gridUnits = (GridUnit[])this.rows.get(i);
                widths[0] = Math.max(widths[0], gridUnits[0].getBorders().getBorderStartWidth(false));
                widths[1] = Math.max(widths[1], gridUnits[gridUnits.length - 1].getBorders().getBorderEndWidth(false));
            }
        }
        return widths;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" startRow=").append(this.startRow);
        return sb.toString();
    }

    public boolean hasSpanning() {
        return this.getCell().getNumberColumnsSpanned() > 1 || this.getCell().getNumberRowsSpanned() > 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

