/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.script;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.script.ScriptTemplateConfig;

public class ScriptTemplateView
extends AbstractUrlBasedView {
    private ScriptEngine engine;
    private String renderObject;
    private String renderFunction;
    private Charset charset;
    private ResourceLoader resourceLoader;

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public void setRenderFunction(String functionName) {
        this.renderFunction = functionName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        ScriptTemplateConfig viewConfig = this.autodetectViewConfig();
        if (this.engine == null) {
            this.engine = viewConfig.getEngine();
            Assert.state((this.engine != null ? 1 : 0) != 0, (String)"Script engine should not be null.");
            Assert.state((boolean)(this.engine instanceof Invocable), (String)"Script engine should be instance of Invocable");
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = viewConfig.getResourceLoader();
        }
        if (this.renderObject == null) {
            this.renderObject = viewConfig.getRenderObject();
        }
        if (this.renderFunction == null) {
            this.renderFunction = viewConfig.getRenderFunction();
        }
        if (this.charset == null) {
            this.charset = viewConfig.getCharset();
        }
    }

    protected ScriptTemplateConfig autodetectViewConfig() throws BeansException {
        try {
            return (ScriptTemplateConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ScriptTemplateConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single ScriptTemplateConfig bean in the current Servlet web application context or the parent root context: ScriptTemplateConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Assert.notNull((Object)"Render function must not be null", (String)this.renderFunction);
        try {
            String template = this.getTemplate(this.getUrl());
            Object html = null;
            if (this.renderObject != null) {
                Object thiz = this.engine.eval(this.renderObject);
                html = ((Invocable)((Object)this.engine)).invokeMethod(thiz, this.renderFunction, template, model);
            } else {
                html = ((Invocable)((Object)this.engine)).invokeFunction(this.renderFunction, template, model);
            }
            response.getWriter().write(String.valueOf(html));
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to render template", e);
        }
    }

    protected String getTemplate(String path) throws IOException {
        Resource resource = this.resourceLoader.getResource(path);
        Assert.state((boolean)resource.exists(), (String)("Resource " + path + " not found."));
        return StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)this.charset);
    }
}

