/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.script.ScriptTemplateConfig;

public class ScriptTemplateConfigurer
implements ScriptTemplateConfig,
ApplicationContextAware,
InitializingBean {
    private ScriptEngine engine;
    private String engineName;
    private ApplicationContext applicationContext;
    private String[] scripts;
    private String renderObject;
    private String renderFunction;
    private Charset charset = Charset.forName("UTF-8");
    private ResourceLoader resourceLoader;
    private String resourceLoaderPath = "classpath:";

    public void setEngine(ScriptEngine engine) {
        Assert.isInstanceOf(Invocable.class, (Object)engine);
        this.engine = engine;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setScripts(String ... scriptNames) {
        this.scripts = scriptNames;
    }

    @Override
    public String getRenderObject() {
        return this.renderObject;
    }

    public void setRenderObject(String renderObject) {
        this.renderObject = renderObject;
    }

    @Override
    public String getRenderFunction() {
        return this.renderFunction;
    }

    public void setRenderFunction(String renderFunction) {
        this.renderFunction = renderFunction;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public String getResourceLoaderPath() {
        return this.resourceLoaderPath;
    }

    @Override
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.engine == null) {
            this.engine = this.createScriptEngine();
        }
        Assert.state((this.renderFunction != null ? 1 : 0) != 0, (String)"renderFunction property must be defined.");
        this.resourceLoader = new DefaultResourceLoader(this.createClassLoader());
        if (this.scripts != null) {
            try {
                for (String script : this.scripts) {
                    this.engine.eval(this.read(script));
                }
            }
            catch (ScriptException e) {
                throw new IllegalStateException("could not load script", e);
            }
        }
    }

    protected ClassLoader createClassLoader() throws IOException {
        String[] paths = StringUtils.commaDelimitedListToStringArray((String)this.resourceLoaderPath);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            Resource[] resources = this.getApplicationContext().getResources(path);
            if (resources.length <= 0) continue;
            for (Resource resource : resources) {
                if (!resource.exists()) continue;
                urls.add(resource.getURL());
            }
        }
        ClassLoader classLoader = this.getApplicationContext().getClassLoader();
        return urls.size() > 0 ? new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader) : classLoader;
    }

    private Reader read(String path) throws IOException {
        Resource resource = this.resourceLoader.getResource(path);
        Assert.state((boolean)resource.exists(), (String)("Resource " + path + " not found."));
        return new InputStreamReader(resource.getInputStream());
    }

    protected ScriptEngine createScriptEngine() throws IOException {
        if (this.engine != null && this.engineName != null) {
            throw new IllegalStateException("You should define engine or engineName properties, not both.");
        }
        if (this.engineName != null) {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(this.engineName);
            Assert.state((scriptEngine != null ? 1 : 0) != 0, (String)("No engine \"" + this.engineName + "\" found."));
            Assert.state((boolean)(scriptEngine instanceof Invocable), (String)"Script engine should be instance of Invocable");
            this.engine = scriptEngine;
        }
        Assert.state((this.engine != null ? 1 : 0) != 0, (String)"No script engine found, please specify valid engine or engineName properties.");
        return this.engine;
    }
}

