/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.http.HttpMethod;
import org.springframework.web.cors.CorsConfiguration;

public class CorsRegistration {
    private final String[] pathPatterns;
    private final CorsConfiguration config;

    public CorsRegistration(String ... pathPatterns) {
        String[] stringArray;
        if (pathPatterns.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/**";
        } else {
            stringArray = pathPatterns;
        }
        this.pathPatterns = stringArray;
        this.config = new CorsConfiguration();
        this.config.addAllowedOrigin("*");
        this.config.addAllowedMethod(HttpMethod.GET.name());
        this.config.addAllowedMethod(HttpMethod.HEAD.name());
        this.config.addAllowedMethod(HttpMethod.POST.name());
        this.config.addAllowedHeader("*");
        this.config.setAllowCredentials(Boolean.valueOf(true));
        this.config.setMaxAge(Long.valueOf(1800L));
    }

    public CorsRegistration allowedOrigins(String ... origins) {
        this.config.setAllowedOrigins(new ArrayList<String>(Arrays.asList(origins)));
        return this;
    }

    public CorsRegistration allowedMethods(String ... methods) {
        this.config.setAllowedMethods(new ArrayList<String>(Arrays.asList(methods)));
        return this;
    }

    public CorsRegistration allowedHeaders(String ... headers) {
        this.config.setAllowedHeaders(new ArrayList<String>(Arrays.asList(headers)));
        return this;
    }

    public CorsRegistration exposedHeaders(String ... headers) {
        this.config.setExposedHeaders(new ArrayList<String>(Arrays.asList(headers)));
        return this;
    }

    public CorsRegistration maxAge(long maxAge) {
        this.config.setMaxAge(Long.valueOf(maxAge));
        return this;
    }

    public CorsRegistration allowCredentials(boolean allowCredentials) {
        this.config.setAllowCredentials(Boolean.valueOf(allowCredentials));
        return this;
    }

    protected String[] getPathPatterns() {
        return this.pathPatterns;
    }

    protected CorsConfiguration getCorsConfiguration() {
        return this.config;
    }
}

