/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Max;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxCheck
extends AbstractAnnotationCheck<Max> {
    private static final long serialVersionUID = 1L;
    private double max;

    @Override
    public void configure(Max constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.value());
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            double doubleValue = ((Number)valueToValidate).doubleValue();
            return doubleValue <= this.max;
        }
        String stringValue = valueToValidate.toString();
        try {
            double doubleValue = Double.parseDouble(stringValue);
            return doubleValue <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setMax(double max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }

    @Override
    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Double.toString(this.max));
        return messageVariables;
    }
}

