/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.JobDataMap;
import org.quartz.jobs.ee.jms.JmsJobException;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class JmsHelper {
    public static final String CREDENTIALS = "java.naming.security.credentials";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String JMS_ACK_MODE = "jms.acknowledge";
    public static final String JMS_CONNECTION_FACTORY_JNDI = "jms.connection.factory";
    public static final String JMS_DESTINATION_JNDI = "jms.destination";
    public static final String JMS_MSG_FACTORY_CLASS_NAME = "jms.message.factory.class.name";
    public static final String JMS_PASSWORD = "jms.password";
    public static final String JMS_USE_TXN = "jms.use.transaction";
    public static final String JMS_USER = "jms.user";
    public static final String PRINCIPAL = "java.naming.security.principal";
    public static final String PROVIDER_URL = "java.naming.provider.url";

    public static void closeResource(Object resource) {
        if (resource == null) {
            return;
        }
        try {
            Method m = resource.getClass().getMethod("close", new Class[0]);
            m.invoke(resource, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InitialContext getInitialContext(JobDataMap dataMap) throws NamingException {
        String credentials;
        String principal;
        String providerUrl;
        Hashtable<String, String> params = new Hashtable<String, String>(4);
        String initialContextFactory = dataMap.getString(INITIAL_CONTEXT_FACTORY);
        if (initialContextFactory != null) {
            params.put(INITIAL_CONTEXT_FACTORY, initialContextFactory);
        }
        if ((providerUrl = dataMap.getString(PROVIDER_URL)) != null) {
            params.put(PROVIDER_URL, providerUrl);
        }
        if ((principal = dataMap.getString(PRINCIPAL)) != null) {
            params.put(PRINCIPAL, principal);
        }
        if ((credentials = dataMap.getString(CREDENTIALS)) != null) {
            params.put(CREDENTIALS, credentials);
        }
        if (params.size() == 0) {
            return new InitialContext();
        }
        return new InitialContext(params);
    }

    public static JmsMessageFactory getMessageFactory(String name) throws JmsJobException {
        try {
            Class<?> cls = Class.forName(name);
            JmsMessageFactory factory = (JmsMessageFactory)cls.newInstance();
            return factory;
        }
        catch (Exception e) {
            throw new JmsJobException(e.getMessage(), e);
        }
    }

    public static boolean isDestinationSecure(JobDataMap dataMap) {
        return dataMap.getString(JMS_USER) != null && dataMap.getString(JMS_PASSWORD) != null;
    }

    public static boolean useTransaction(JobDataMap dataMap) {
        return dataMap.getBoolean(JMS_USE_TXN);
    }

    private JmsHelper() {
    }
}

