/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.util.ArrayList;
import java.util.ServiceLoader;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.EhcacheInit;

final class LibraryInit {
    private static final CacheException NO_ERROR = new CacheException();
    private static CacheException initError = null;

    private LibraryInit() {
    }

    static synchronized void init() {
        if (initError != null) {
            if (initError == NO_ERROR) {
                return;
            }
            throw initError;
        }
        try {
            LibraryInit.initService();
        }
        catch (Throwable t) {
            initError = t instanceof CacheException ? (CacheException)t : new CacheException(t);
            throw initError;
        }
        initError = NO_ERROR;
    }

    private static void initService() {
        ArrayList<EhcacheInit> initializers = new ArrayList<EhcacheInit>();
        for (EhcacheInit init : ServiceLoader.load(EhcacheInit.class)) {
            initializers.add(init);
        }
        if (initializers.isEmpty()) {
            for (EhcacheInit init : ServiceLoader.load(EhcacheInit.class, CacheManager.class.getClassLoader())) {
                initializers.add(init);
            }
        }
        if (initializers.isEmpty()) {
            throw new AssertionError((Object)("No " + EhcacheInit.class.getName() + " services found"));
        }
        if (initializers.size() > 1) {
            throw new CacheException("Found multiple initialization services. Do you have multiple ehcache jars present in your classpath? " + initializers);
        }
        for (EhcacheInit init : initializers) {
            init.init();
        }
    }
}

