/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

class RegionSet {
    private static final Region NULL_NODE = new Region();
    private final long size;
    private Region root;
    private Region deletedNode;
    private Region lastNode;
    private Region deletedElement;

    protected RegionSet(long size) {
        this.size = size;
        this.root = new Region(0L, size - 1L);
    }

    protected void insert(Region x) {
        this.root = this.insert(x, this.root);
    }

    protected Region remove(Region x) {
        this.deletedNode = NULL_NODE;
        this.root = this.remove(x, this.root);
        Region d = this.deletedElement;
        this.deletedElement = null;
        if (d == null) {
            return null;
        }
        return new Region(d);
    }

    protected Region find(long size) {
        Region current = this.root;
        if (size > current.contiguous()) {
            throw new IllegalArgumentException("Need to grow the region set");
        }
        while (true) {
            if (current.size() >= size) {
                return new Region(current.start, current.start + size - 1L);
            }
            if (current.left.contiguous() >= size) {
                current = current.left;
                continue;
            }
            if (current.right.contiguous() < size) break;
            current = current.right;
        }
        throw new IllegalArgumentException("Couldn't find a " + size + " sized free area in " + current.dump());
    }

    protected Region findMin() {
        if (this.isEmpty()) {
            return null;
        }
        Region ptr = this.root;
        while (ptr.left != NULL_NODE) {
            ptr = ptr.left;
        }
        return ptr;
    }

    protected Region findMax() {
        if (this.isEmpty()) {
            return null;
        }
        Region ptr = this.root;
        while (ptr.right != NULL_NODE) {
            ptr = ptr.right;
        }
        return ptr;
    }

    protected Region find(Region x) {
        Region current = this.root;
        while (current != NULL_NODE) {
            int res = x.compareTo(current);
            if (res < 0) {
                current = current.left;
                continue;
            }
            if (res > 0) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    protected void clear() {
        this.root = new Region(0L, this.size - 1L);
    }

    protected boolean isEmpty() {
        return this.root == NULL_NODE;
    }

    private Region insert(Region x, Region t) {
        if (t == NULL_NODE) {
            t = x;
        } else if (x.compareTo(t) < 0) {
            t.left(this.insert(x, t.left));
        } else if (x.compareTo(t) > 0) {
            t.right(this.insert(x, t.right));
        } else {
            throw new IllegalArgumentException("Cannot insert " + x + " into " + this);
        }
        t = RegionSet.skew(t);
        t = RegionSet.split(t);
        return t;
    }

    private Region remove(Comparable x, Region t) {
        if (t != NULL_NODE) {
            this.lastNode = t;
            if (x.compareTo(t) < 0) {
                t.left(this.remove(x, t.left));
            } else {
                this.deletedNode = t;
                t.right(this.remove(x, t.right));
            }
            if (t == this.lastNode) {
                if (this.deletedNode != NULL_NODE && x.compareTo(this.deletedNode) == 0) {
                    this.deletedNode.swap(t);
                    this.deletedElement = t;
                    t = t.right;
                }
            } else if (t.left.level < t.level - 1 || t.right.level < t.level - 1) {
                if (t.right.level > --t.level) {
                    t.right.level = t.level;
                }
                t = RegionSet.skew(t);
                t.right(RegionSet.skew(t.right));
                t.right.right(RegionSet.skew(t.right.right));
                t = RegionSet.split(t);
                t.right(RegionSet.split(t.right));
            }
        }
        return t;
    }

    private static Region skew(Region t) {
        if (t.left.level == t.level) {
            t = RegionSet.rotateWithLeftChild(t);
        }
        return t;
    }

    private static Region split(Region t) {
        if (t.right.right.level == t.level) {
            t = RegionSet.rotateWithRightChild(t);
            t.level++;
        }
        return t;
    }

    private static Region rotateWithLeftChild(Region k2) {
        Region k1 = k2.left;
        k2.left(k1.right);
        k1.right(k2);
        return k1;
    }

    private static Region rotateWithRightChild(Region k1) {
        Region k2 = k1.right;
        k1.right(k2.left);
        k2.left(k1);
        return k2;
    }

    public String toString() {
        return "RegionSet = { " + this.root.dump() + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Region
    implements Comparable<Region> {
        private Region left;
        private Region right;
        private int level;
        private long start;
        private long end;
        private long contiguous;

        private Region() {
            this.start = 1L;
            this.end = 0L;
            this.level = 0;
            this.left = this;
            this.right = this;
            this.contiguous = this.size();
        }

        public Region(long value) {
            this(value, value);
        }

        public Region(long start, long end) {
            this.start = start;
            this.end = end;
            this.left = NULL_NODE;
            this.right = NULL_NODE;
            this.level = 1;
            this.updateContiguous();
        }

        public Region(Region r) {
            this(r.start(), r.end());
        }

        private long contiguous() {
            if (this.left == NULL_NODE && this.right == NULL_NODE) {
                return this.size();
            }
            return this.contiguous;
        }

        private void updateContiguous() {
            this.contiguous = Math.max(this.size(), Math.max(this.left.contiguous(), this.right.contiguous()));
        }

        private void left(Region l) {
            this.left = l;
            this.updateContiguous();
        }

        private void right(Region r) {
            this.right = r;
            this.updateContiguous();
        }

        public String toString() {
            return "Range(" + this.start + "," + this.end + ")" + " contiguous:" + this.contiguous();
        }

        private String dump() {
            String ds = "";
            if (this.left != NULL_NODE) {
                ds = this.left.dump();
                ds = ds + "," + String.valueOf(this);
            } else {
                ds = ds + String.valueOf(this);
            }
            if (this.right != NULL_NODE) {
                ds = ds + "," + this.right.dump();
            }
            return ds;
        }

        public long size() {
            return this.isNull() ? 0L : this.end - this.start + 1L;
        }

        protected boolean isNull() {
            return this.start > this.end;
        }

        protected Region remove(Region r) throws IllegalArgumentException {
            if (r.start < this.start || r.end > this.end) {
                throw new IllegalArgumentException("Ranges : Illegal value passed to remove : " + this + " remove called for : " + r);
            }
            if (this.start == r.start) {
                this.start = r.end + 1L;
                this.updateContiguous();
                return null;
            }
            if (this.end == r.end) {
                this.end = r.start - 1L;
                this.updateContiguous();
                return null;
            }
            Region newRegion = new Region(r.end + 1L, this.end);
            this.end = r.start - 1L;
            this.updateContiguous();
            return newRegion;
        }

        protected void merge(Region r) throws IllegalArgumentException {
            if (this.start == r.end + 1L) {
                this.start = r.start;
            } else if (this.end == r.start - 1L) {
                this.end = r.end;
            } else {
                throw new IllegalArgumentException("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r);
            }
            this.updateContiguous();
        }

        @Override
        public int compareTo(Region other) {
            if (this.start < other.start) {
                return -1;
            }
            if (this.end > other.end) {
                return 1;
            }
            return 0;
        }

        private void swap(Region other) {
            Region r = other;
            long temp = this.start;
            this.start = r.start;
            r.start = temp;
            temp = this.end;
            this.end = r.end;
            r.end = temp;
            this.updateContiguous();
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }
    }
}

